//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';
import 'bioseal_native.dart';

import '../id3_bioseal.dart';

final _finalizer = NativeFinalizer(biosealSDK.addresses.id3BiosealDateTimeArray_Dispose.cast());

/// Represents an array of DateTime objects.
class DateTimeArray extends Object with IterableMixin<DateTime> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3BiosealDateTimeArray>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3BiosealDateTimeArray> get handle => _pHandle.value;

  /// Creates a new instance of the DateTimeArray class.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  DateTimeArray() {
    _pHandle = calloc();
    try {
      var err = biosealSDK.id3BiosealDateTimeArray_Initialize(_pHandle);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the DateTimeArray class.
  ///
  /// param handle     Handle to the DateTimeArray.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  DateTimeArray.fromHandle(Pointer<id3BiosealDateTimeArray> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this DateTimeArray.
  void dispose() {
    if (_disposable) {
      biosealSDK.id3BiosealDateTimeArray_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<DateTime> get iterator => DateTimeArrayIterator(this);

  // Public methods
  /// Gets an item of the DateTimeArray object.
  ///
  /// param index Index of the DateTime item to get.
  /// return DateTime item to get.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  DateTime get(int index) {
    DateTime dateTimeItem = DateTime();
    var err = biosealSDK.id3BiosealDateTimeArray_Get(_pHandle.value, index, dateTimeItem.handle);
    if (err != BiosealError.success.value) {
      dateTimeItem.dispose();
      throw BiosealException(err);
    }
    return dateTimeItem;
  }

  /// Gets the number of elements in the DateTimeArray object.
  ///
  /// return Number of elements in the DateTime object.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = biosealSDK.id3BiosealDateTimeArray_GetCount(_pHandle.value, pCount);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

}

class DateTimeArrayIterator implements Iterator<DateTime> {
  DateTimeArrayIterator(this._list) : _count = _list.getCount();
  final DateTimeArray _list;
  final int _count;
  int _index = -1;

  @override
  DateTime get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
