//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:convert';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';
import 'bioseal_native.dart';

import '../id3_bioseal.dart';

final _finalizer = NativeFinalizer(biosealSDK.addresses.id3BiosealExtension_Dispose.cast());

/// Represents an extension.
class Extension extends Object with IterableMixin<String> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3BiosealExtension>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3BiosealExtension> get handle => _pHandle.value;

  /// Creates a new instance of the Extension class.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Extension() {
    _pHandle = calloc();
    try {
      var err = biosealSDK.id3BiosealExtension_Initialize(_pHandle);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the Extension class.
  ///
  /// param handle     Handle to the Extension.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Extension.fromHandle(Pointer<id3BiosealExtension> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this Extension.
  void dispose() {
    if (_disposable) {
      biosealSDK.id3BiosealExtension_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  /// Gets or sets the element at the specified index.
  operator [](String key) => get(key);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<String> get iterator => ExtensionIterator(this);

  ///
  /// The extension name.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get name => getName();

  ///
  /// Gets a string list containing the keys in the dict.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  StringArray get keys => getKeys();

  // Public methods
  /// Gets an item of the Extension object.
  ///
  /// param key Unique key of the  item to get.
  /// return  item to get.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String get(String? key) {
    Pointer<Char>? pKey = key?.toNativeUtf8().cast<Char>();
    Pointer<Char> pItem = nullptr;
    Pointer<Int> pItemSize = calloc.allocate(1);
    pItemSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealExtension_Get(_pHandle.value, pKey ?? nullptr, pItem, pItemSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pItem = calloc.allocate(pItemSize.value);
        err = biosealSDK.id3BiosealExtension_Get(_pHandle.value, pKey ?? nullptr, pItem, pItemSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vItem = utf8.decode(Uint8List.fromList(pItem.cast<Uint8>().asTypedList(pItemSize.value)));
      return vItem;
    } finally {
      if (pKey != null) {
        calloc.free(pKey);
      }
      calloc.free(pItem);
      calloc.free(pItemSize);
    }
  }

  /// Gets the number of elements in the Extension object.
  ///
  /// return Number of elements in the  object.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = biosealSDK.id3BiosealExtension_GetCount(_pHandle.value, pCount);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Determines whether the Extensionobject contains the specified key.
  ///
  /// param key The key to locate in the  object.
  /// return true if the  object contains an element with the specified key, otherwise false.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  bool containsKey(String? key) {
    Pointer<Char>? pKey = key?.toNativeUtf8().cast<Char>();
    Pointer<Bool> pResult = calloc();
    try {
      var err = biosealSDK.id3BiosealExtension_ContainsKey(_pHandle.value, pKey ?? nullptr, pResult);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vResult = pResult.value;
      return vResult;
    } finally {
      if (pKey != null) {
        calloc.free(pKey);
      }
      calloc.free(pResult);
    }
  }

  /// Gets the the extension name.
  ///
  /// return The extension name.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  String getName() {
    Pointer<Char> pName = nullptr;
    Pointer<Int> pNameSize = calloc.allocate(1);
    pNameSize[0] = -1;
    try {
      var err = biosealSDK.id3BiosealExtension_GetName(_pHandle.value, pName, pNameSize);
      if (err == BiosealError.insufficientBuffer.value) {
        pName = calloc.allocate(pNameSize.value);
        err = biosealSDK.id3BiosealExtension_GetName(_pHandle.value, pName, pNameSize);
        if (err != BiosealError.success.value) {
          throw BiosealException(err);
        }
      }
      final vName = utf8.decode(Uint8List.fromList(pName.cast<Uint8>().asTypedList(pNameSize.value)));
      return vName;
    } finally {
      calloc.free(pName);
      calloc.free(pNameSize);
    }
  }

  /// Gets the gets a string list containing the keys in the dict.
  ///
  /// return Gets a string list containing the keys in the dict.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  StringArray getKeys() {
    StringArray keys = StringArray();
    var err = biosealSDK.id3BiosealExtension_GetKeys(_pHandle.value, keys.handle);
    if (err != BiosealError.success.value) {
      keys.dispose();
      throw BiosealException(err);
    }
    return keys;
  }

}

class ExtensionIterator implements Iterator<String> {
  ExtensionIterator(this._list)
      : _count = _list.getCount(),
        _keys = [] {
    final StringArray keys = _list.getKeys();
    for (var key in keys) {
      _keys.add(key);
    }
    keys.dispose();
  }
  final Extension _list;
  final int _count;
  int _index = -1;
  final List<String> _keys;

  @override
  String get current => _list.get(_keys[_index]);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
