//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';
import 'bioseal_native.dart';

import '../id3_bioseal.dart';

final _finalizer = NativeFinalizer(biosealSDK.addresses.id3BiosealExtensionList_Dispose.cast());

/// Represents a list of extensions.
class ExtensionList extends Object with IterableMixin<Extension> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3BiosealExtensionList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3BiosealExtensionList> get handle => _pHandle.value;

  /// Creates a new instance of the ExtensionList class.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  ExtensionList() {
    _pHandle = calloc();
    try {
      var err = biosealSDK.id3BiosealExtensionList_Initialize(_pHandle);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the ExtensionList class.
  ///
  /// param handle     Handle to the ExtensionList.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  ExtensionList.fromHandle(Pointer<id3BiosealExtensionList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this ExtensionList.
  void dispose() {
    if (_disposable) {
      biosealSDK.id3BiosealExtensionList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  /// Gets or sets the element at the specified index.
  operator [](String key) => get(key);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<Extension> get iterator => ExtensionListIterator(this);

  ///
  /// Gets a string list containing the keys in the dict.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  StringArray get keys => getKeys();

  // Public methods
  /// Gets an item of the ExtensionList object.
  ///
  /// param key Unique key of the Extension item to get.
  /// return Extension item to get.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Extension get(String? key) {
    Pointer<Char>? pKey = key?.toNativeUtf8().cast<Char>();
    Extension extensionItem = Extension();
    try {
      var err = biosealSDK.id3BiosealExtensionList_Get(_pHandle.value, pKey ?? nullptr, extensionItem.handle);
      if (err != BiosealError.success.value) {
        extensionItem.dispose();
        throw BiosealException(err);
      }
      return extensionItem;
    } finally {
      if (pKey != null) {
        calloc.free(pKey);
      }
    }
  }

  /// Gets the number of elements in the ExtensionList object.
  ///
  /// return Number of elements in the Extension object.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = biosealSDK.id3BiosealExtensionList_GetCount(_pHandle.value, pCount);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Determines whether the ExtensionListobject contains the specified key.
  ///
  /// param key The key to locate in the Extension object.
  /// return true if the Extension object contains an element with the specified key, otherwise false.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  bool containsKey(String? key) {
    Pointer<Char>? pKey = key?.toNativeUtf8().cast<Char>();
    Pointer<Bool> pResult = calloc();
    try {
      var err = biosealSDK.id3BiosealExtensionList_ContainsKey(_pHandle.value, pKey ?? nullptr, pResult);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vResult = pResult.value;
      return vResult;
    } finally {
      if (pKey != null) {
        calloc.free(pKey);
      }
      calloc.free(pResult);
    }
  }

  /// Gets the gets a string list containing the keys in the dict.
  ///
  /// return Gets a string list containing the keys in the dict.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  StringArray getKeys() {
    StringArray keys = StringArray();
    var err = biosealSDK.id3BiosealExtensionList_GetKeys(_pHandle.value, keys.handle);
    if (err != BiosealError.success.value) {
      keys.dispose();
      throw BiosealException(err);
    }
    return keys;
  }

  /// Clear the list.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  void clear() {
    var err = biosealSDK.id3BiosealExtensionList_Clear(_pHandle.value);
    if (err != BiosealError.success.value) {
      throw BiosealException(err);
    }
  }

}

class ExtensionListIterator implements Iterator<Extension> {
  ExtensionListIterator(this._list)
      : _count = _list.getCount(),
        _keys = [] {
    final StringArray keys = _list.getKeys();
    for (var key in keys) {
      _keys.add(key);
    }
    keys.dispose();
  }
  final ExtensionList _list;
  final int _count;
  int _index = -1;
  final List<String> _keys;

  @override
  Extension get current => _list.get(_keys[_index]);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
