//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the field extension types.
enum FieldExtensionType {
	/// No information given.
	none,
	/// No information given.
	unknown,
	/// The Image extension specifies the expected type and format of the image data.
	image,
	/// The Portrait extension specifies the guidelines to create the portrait image.
	portrait,
	/// The Biometric extension specifies the expected type and format of the biometric data in the payload.
	biometric,
	/// The Compression extension specifies the compression parameters.
	compression,
	/// The Encryption extension is used to maintain the confidentiality of specific data in the payload.
	encryption,
}

extension FieldExtensionTypeX on FieldExtensionType {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created FieldExtensionType.
  	static FieldExtensionType fromValue(int value) {
    	switch (value) {
      	case 0:
        	return FieldExtensionType.none;
      	case 1:
        	return FieldExtensionType.unknown;
      	case 2:
        	return FieldExtensionType.image;
      	case 3:
        	return FieldExtensionType.portrait;
      	case 4:
        	return FieldExtensionType.biometric;
      	case 5:
        	return FieldExtensionType.compression;
      	case 6:
        	return FieldExtensionType.encryption;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case FieldExtensionType.none:
        	return 0;
      	case FieldExtensionType.unknown:
        	return 1;
      	case FieldExtensionType.image:
        	return 2;
      	case FieldExtensionType.portrait:
        	return 3;
      	case FieldExtensionType.biometric:
        	return 4;
      	case FieldExtensionType.compression:
        	return 5;
      	case FieldExtensionType.encryption:
        	return 6;
		}
  	}
}
