//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';
import 'bioseal_native.dart';

import '../id3_bioseal.dart';

final _finalizer = NativeFinalizer(biosealSDK.addresses.id3BiosealFieldList_Dispose.cast());

/// Represents a list of Field objects.
class FieldList extends Object with IterableMixin<Field> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3BiosealFieldList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3BiosealFieldList> get handle => _pHandle.value;

  /// Creates a new instance of the FieldList class.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  FieldList() {
    _pHandle = calloc();
    try {
      var err = biosealSDK.id3BiosealFieldList_Initialize(_pHandle);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the FieldList class.
  ///
  /// param handle     Handle to the FieldList.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  FieldList.fromHandle(Pointer<id3BiosealFieldList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this FieldList.
  void dispose() {
    if (_disposable) {
      biosealSDK.id3BiosealFieldList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<Field> get iterator => FieldListIterator(this);

  // Public methods
  /// Gets an item of the FieldList object.
  ///
  /// param index Index of the Field item to get.
  /// return Field item to get.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  Field get(int index) {
    Field fieldItem = Field();
    var err = biosealSDK.id3BiosealFieldList_Get(_pHandle.value, index, fieldItem.handle);
    if (err != BiosealError.success.value) {
      fieldItem.dispose();
      throw BiosealException(err);
    }
    return fieldItem;
  }

  /// Gets the number of elements in the FieldList object.
  ///
  /// return Number of elements in the Field object.
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = biosealSDK.id3BiosealFieldList_GetCount(_pHandle.value, pCount);
      if (err != BiosealError.success.value) {
        throw BiosealException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Clear the list.
  ///
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  void clear() {
    var err = biosealSDK.id3BiosealFieldList_Clear(_pHandle.value);
    if (err != BiosealError.success.value) {
      throw BiosealException(err);
    }
  }

}

class FieldListIterator implements Iterator<Field> {
  FieldListIterator(this._list) : _count = _list.getCount();
  final FieldList _list;
  final int _count;
  int _index = -1;

  @override
  Field get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
