//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the field types present in the payload.
enum FieldType {
	/// Unknown type.
	unknown,
	/// Integer.
	integer,
	/// Boolean.
	boolean,
	/// Float.
	float,
	/// String.
	string,
	/// Binary.
	binary,
	/// Date.
	date,
	/// Value representing the number of seconds since 1970-01-01 00:00:00 UTC.
	timestamp,
	/// Time.
	time,
	/// Object.
	object,
	/// Integer array.
	integerArray,
	/// Boolean array.
	booleanArray,
	/// Float array.
	floatArray,
	/// String array.
	stringArray,
	/// Binary array.
	binaryArray,
	/// Date array.
	dateArray,
	/// Date array.
	timestampArray,
	/// Object array.
	objectArray,
}

extension FieldTypeX on FieldType {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created FieldType.
  	static FieldType fromValue(int value) {
    	switch (value) {
      	case 0:
        	return FieldType.unknown;
      	case 1:
        	return FieldType.integer;
      	case 2:
        	return FieldType.boolean;
      	case 3:
        	return FieldType.float;
      	case 4:
        	return FieldType.string;
      	case 5:
        	return FieldType.binary;
      	case 6:
        	return FieldType.date;
      	case 7:
        	return FieldType.timestamp;
      	case 8:
        	return FieldType.time;
      	case 9:
        	return FieldType.object;
      	case 10:
        	return FieldType.integerArray;
      	case 11:
        	return FieldType.booleanArray;
      	case 12:
        	return FieldType.floatArray;
      	case 13:
        	return FieldType.stringArray;
      	case 14:
        	return FieldType.binaryArray;
      	case 15:
        	return FieldType.dateArray;
      	case 16:
        	return FieldType.timestampArray;
      	case 17:
        	return FieldType.objectArray;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case FieldType.unknown:
        	return 0;
      	case FieldType.integer:
        	return 1;
      	case FieldType.boolean:
        	return 2;
      	case FieldType.float:
        	return 3;
      	case FieldType.string:
        	return 4;
      	case FieldType.binary:
        	return 5;
      	case FieldType.date:
        	return 6;
      	case FieldType.timestamp:
        	return 7;
      	case FieldType.time:
        	return 8;
      	case FieldType.object:
        	return 9;
      	case FieldType.integerArray:
        	return 10;
      	case FieldType.booleanArray:
        	return 11;
      	case FieldType.floatArray:
        	return 12;
      	case FieldType.stringArray:
        	return 13;
      	case FieldType.binaryArray:
        	return 14;
      	case FieldType.dateArray:
        	return 15;
      	case FieldType.timestampArray:
        	return 16;
      	case FieldType.objectArray:
        	return 17;
		}
  	}
}
