//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'bioseal_sdk_generated_bindings.dart';

/// Contains data for LibVersion
class LibVersion {
  final Pointer<id3BiosealLibVersion> _handle;

  static final Finalizer<Pointer<id3BiosealLibVersion>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3BiosealLibVersion> get handle => _handle;

  id3BiosealLibVersion get struct => _handle.ref;

  /// Initializes a new instance of the LibVersion class from its members.
  LibVersion(this._handle);

  /// Create a new instance of the LibVersion.
  LibVersion.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the LibVersion from the native struct
  LibVersion.createFromStruct(id3BiosealLibVersion value) : _handle = calloc() {
    _handle.ref.Major = value.Major;
    _handle.ref.Minor = value.Minor;
    _handle.ref.Build = value.Build;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Version.
  /// 
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int get major => _handle.ref.Major;
  set major(int value) => _handle.ref.Major = value;

  /// 
  /// Release.
  /// 
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int get minor => _handle.ref.Minor;
  set minor(int value) => _handle.ref.Minor = value;

  /// 
  /// Build.
  /// 
  /// throws BiosealException An error has occurred during Bioseal Library execution.
  int get build => _handle.ref.Build;
  set build(int value) => _handle.ref.Build = value;


  Map<String, dynamic> toMap() {
    return {
        'major': major,
        'minor': minor,
        'build': build,
    };
  }
}
