//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the log item types.
enum LogItemType {
	/// The log item is an undefined.
	undefined,
	/// The log item is an information.
	information,
	/// The log item is a warning.
	warning,
	/// The log item is an error.
	error,
	/// The log item is for debug only.
	debug,
}

extension LogItemTypeX on LogItemType {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created LogItemType.
  	static LogItemType fromValue(int value) {
    	switch (value) {
      	case 0:
        	return LogItemType.undefined;
      	case 1:
        	return LogItemType.information;
      	case 2:
        	return LogItemType.warning;
      	case 3:
        	return LogItemType.error;
      	case 4:
        	return LogItemType.debug;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case LogItemType.undefined:
        	return 0;
      	case LogItemType.information:
        	return 1;
      	case LogItemType.warning:
        	return 2;
      	case LogItemType.error:
        	return 3;
      	case LogItemType.debug:
        	return 4;
		}
  	}
}
