//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the resource type for resource callback args.
enum ResourceType {
	/// The resource is a undefined.
	undefined,
	/// The resource is a manifest.
	manifest,
	/// The resource is a certificate.
	certificate,
	/// The resource is a TSL.
	tsl,
	/// The resource is a CRL.
	crl,
	/// The resource is a LOTL.
	lotl,
	/// The resource is a PKCS7 P7S file.
	p7S,
}

extension ResourceTypeX on ResourceType {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created ResourceType.
  	static ResourceType fromValue(int value) {
    	switch (value) {
      	case 0:
        	return ResourceType.undefined;
      	case 1:
        	return ResourceType.manifest;
      	case 2:
        	return ResourceType.certificate;
      	case 3:
        	return ResourceType.tsl;
      	case 4:
        	return ResourceType.crl;
      	case 5:
        	return ResourceType.lotl;
      	case 6:
        	return ResourceType.p7S;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case ResourceType.undefined:
        	return 0;
      	case ResourceType.manifest:
        	return 1;
      	case ResourceType.certificate:
        	return 2;
      	case ResourceType.tsl:
        	return 3;
      	case ResourceType.crl:
        	return 4;
      	case ResourceType.lotl:
        	return 5;
      	case ResourceType.p7S:
        	return 6;
		}
  	}
}
