//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the user authentication methods.
enum UserAuthenticationMethod {
	/// The method is undefined.
	undefined,
	/// A password must be entered to authenticate.
	password,
	/// The user must present a biometric trait to authenticate.
	biometrics,
}

extension UserAuthenticationMethodX on UserAuthenticationMethod {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created UserAuthenticationMethod.
  	static UserAuthenticationMethod fromValue(int value) {
    	switch (value) {
      	case 0:
        	return UserAuthenticationMethod.undefined;
      	case 1:
        	return UserAuthenticationMethod.password;
      	case 2:
        	return UserAuthenticationMethod.biometrics;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case UserAuthenticationMethod.undefined:
        	return 0;
      	case UserAuthenticationMethod.password:
        	return 1;
      	case UserAuthenticationMethod.biometrics:
        	return 2;
		}
  	}
}
