import 'dart:io';
import 'package:id3_bioseal/id3_bioseal.dart';

int biosealGetExternalResourceCallback(Object sender, ResourceCallbackArgs args) {
  final String filename = args.resourceName;
  args.outputData = File("../../data/$filename").readAsBytesSync();
  return BiosealError.success.value;
}

final ffff0fId3Fingerprints =
    "3gJmNR/lGkX//w9i6S3YAbGkV2lja6RKb2huwMC4VW5pdGVkLVN0YXRlcyBvZiBBbWVyaWNhoU2jVVNBwMDAwMDNAdbAwMDAxIwAPyGb4htnwNnvFkC1wmRfqLK60KTInK+gm2XQc6MdPoew7sjKr2T/vWOIm9CgjYB1X3qhU155j9Zfq5B9nXmT59O9uJPfAIlFd46cxvmPnEx0qcm4ap+FX8bGf5WB8ISakHFywXmgxdKGuZxmerCUibu3jKZrlZOw2ZBxmiuSGX5xVkzQn5yZhXqp9ZKSAcRyZTJ+ekt7NlKnSGKCF2OJRXCnUnG/X3m5N3yHVn96IYCrR4FDhoh2TIm8S5BqUZRxSpZsTZyuipx2U6GvdKSyGqhuf6tzaq2whq10LrdMYL1uJ8WLesVwHseNN8doistyMMyIGNONJdaJM9dIU9tpeNutkgLEcWUyfnpLezZSp0highdjiUVwp1Jxv195uTd8h1Z/eiGAq0eBQ4aIdkyJvEuQalGUcUqWbE2croqcdlOhr3Skshqobn+rc2qtsIatdC63TGC9bifFi3rFcB7HjTfHaIrLcjDMiBjTjSXWiTPXSFPbaXjb5zKK20CKePn8B9xVTl3rhvTQ6Ape6x3svls+8su+Avgx/pgMYpUN03cC6dlEenPASiZgQ4cdYhMoIyVzWD47AA==";
void main() {
  //test('init', () {
  final bioseal = Bioseal();
  bioseal.externalResourceCallback = biosealGetExternalResourceCallback;
  bioseal.verifiesGovernance = false;
  bioseal.verifiesSignature = false;
  bioseal.verifyFromString(ffff0fId3Fingerprints);

  /*if (bioseal.containsFaceTemplates) {
    final faceTemplateFieldList = bioseal.findBiometrics(BiometricDataType.facialFeatures, null);

    //final count = faceTemplateFieldList.getCount();

    for (var faceTemplateField in faceTemplateFieldList) {
      print(faceTemplateField.name);
      faceTemplateField.dispose();
    }

    /*for (int i = 0; i < faceTemplateFieldList.getCount(); i++) {
      final Field faceTemplateField = faceTemplateFieldList.get(i);
      print(faceTemplateField.name);
      faceTemplateField.dispose();
    }*/
    faceTemplateFieldList.dispose();
  }*/

  final payload = bioseal.payload;

  for (var field in payload) {
    print(field.name);
    field.dispose();
  }

  /*final keys = payload.keys;
  for (int i = 0; i < keys.getCount(); i++) {
    final key = keys.get(i);
    final Field field = payload.get(key);
    //print("$key: ${field.name}");
    field.dispose();
  }*/

  /*for (Field field in payload) {
      print("${field.name}");
    }*/

  payload.dispose();

  bioseal.dispose();
}
