//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealBiometricDataType_h
#define _id3BiosealBiometricDataType_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the supported biometric data types.
 */
typedef enum id3BiosealBiometricDataType {
	/**
	 * The biometric data type is a undefined.
	 */
	id3BiosealBiometricDataType_Undefined = 0,
	/**
	 * No information given.
	 */
	id3BiosealBiometricDataType_NoInformationGiven = 1,
	/**
	 * Multiple biometric data used.
	 */
	id3BiosealBiometricDataType_MultipleBiometricsUsed = 2,
	/**
	 * Facial features data.
	 */
	id3BiosealBiometricDataType_FacialFeatures = 3,
	/**
	 * Voice data.
	 */
	id3BiosealBiometricDataType_Voice = 4,
	/**
	 * Fingerprint data.
	 */
	id3BiosealBiometricDataType_Fingerprint = 5,
	/**
	 * Iris data.
	 */
	id3BiosealBiometricDataType_Iris = 6,
	/**
	 * Retina data.
	 */
	id3BiosealBiometricDataType_Retina = 7,
	/**
	 * Hand geometry.
	 */
	id3BiosealBiometricDataType_HandGeometry = 8,
	/**
	 * Signature dynamics.
	 */
	id3BiosealBiometricDataType_SignatureDynamics = 9,
	/**
	 * Keystroke dynamics.
	 */
	id3BiosealBiometricDataType_KeystrokeDynamics = 10,
	/**
	 * Lip movement.
	 */
	id3BiosealBiometricDataType_LipMovement = 11,
	/**
	 * Thermal face image.
	 */
	id3BiosealBiometricDataType_ThermalFaceImage = 12,
	/**
	 * Thermal hand image.
	 */
	id3BiosealBiometricDataType_ThermalHandImage = 13,
	/**
	 * Gait.
	 */
	id3BiosealBiometricDataType_Gait = 14,
	/**
	 * Body odor.
	 */
	id3BiosealBiometricDataType_BodyOdor = 15,
	/**
	 * DNA.
	 */
	id3BiosealBiometricDataType_Dna = 16,
	/**
	 * Ear shape.
	 */
	id3BiosealBiometricDataType_EarShape = 17,
	/**
	 * Finger geometry.
	 */
	id3BiosealBiometricDataType_FingerGeometry = 18,
	/**
	 * Palmprint data.
	 */
	id3BiosealBiometricDataType_PalmPrint = 19,
	/**
	 * Vein pattern
	 */
	id3BiosealBiometricDataType_VeinPattern = 20,
	/**
	 * Footprint data.
	 */
	id3BiosealBiometricDataType_FootPrint = 21,
} id3BiosealBiometricDataType;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetBiometricDataTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
