//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealError_h
#define _id3BiosealError_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the error codes.
 */
typedef enum id3BiosealError {
	/**
	 * No error.
	 */
	id3BiosealError_Success = 0,
	/**
	 * The given buffer is too small.
	 */
	id3BiosealError_InsufficientBuffer = -1,
	/**
	 * The requested object does not exist; a 'null' should be returned if possible.
	 */
	id3BiosealError_ObjectDoesNotExist = -2,
	/**
	 * Base error code for BioSeal module.
	 */
	id3BiosealError_Base = -8000,
	/**
	 * Minimum error code for BioSeal module.
	 */
	id3BiosealError_Minimum = -8999,
	/**
	 * The handle is invalid.
	 */
	id3BiosealError_InvalidHandle = -8001,
	/**
	 * The parameter is invalid.
	 */
	id3BiosealError_InvalidParameter = -8002,
	/**
	 * An exception was fired in the callback.
	 */
	id3BiosealError_ExceptionInCallback = -8003,
	/**
	 * An exception was fired in JNI.
	 */
	id3BiosealError_JavaException = -8004,
	/**
	 * Resource not found.
	 */
	id3BiosealError_ResourceNotFound = -8005,
	/**
	 * An internal error has been fired.
	 */
	id3BiosealError_MemoryError = -8006,
	/**
	 * An memory error has been fired.
	 */
	id3BiosealError_InternalError = -8007,
	/**
	 * Error in the internal download process.
	 */
	id3BiosealError_DownloadError = -8008,
	/**
	 * Invalid input format.
	 */
	id3BiosealError_InvalidInputFormat = -8009,
	/**
	 * The LOTL is malformed.
	 */
	id3BiosealError_BadInputLotl = -8010,
	/**
	 * The TSL does not conform to ETSI TS 119 612.
	 */
	id3BiosealError_BadInputTsl = -8011,
	/**
	 * The manifest is malformed.
	 */
	id3BiosealError_BadInputManifest = -8012,
	/**
	 * An unsupported Afnor XP Z42-101 identifier was found.
	 */
	id3BiosealError_UnsupportedAfnorXpZ42_101Id = -8013,
	/**
	 * Decoding failed.
	 */
	id3BiosealError_DecodingFailed = -8014,
	/**
	 * The BioSeal as expired.
	 */
	id3BiosealError_BiosealExpired = -8015,
	/**
	 * Invalid certification chain.
	 */
	id3BiosealError_InvalidCertificationChain = -8016,
	/**
	 * Invalid signature.
	 */
	id3BiosealError_InvalidSignature = -8017,
	/**
	 * Authorized usage failed.
	 */
	id3BiosealError_AuthorizedUsageFailed = -8018,
	/**
	 * The signing certificate was expired when the BioSeal was generated.
	 */
	id3BiosealError_SigningCertificateExpired = -8019,
	/**
	 * Invalid revocation info validity period.
	 */
	id3BiosealError_RevocationInfoValidityPeriod = -8020,
	/**
	 * An unexpected error occurred during decryption..
	 */
	id3BiosealError_DecryptionError = -8021,
	/**
	 * Language not found.
	 */
	id3BiosealError_LanguageNotAvailable = -8022,
	/**
	 * The BioSeal was not decoded.
	 */
	id3BiosealError_BiosealNotDecoded = -8023,
	/**
	 * Function or request not supported.
	 */
	id3BiosealError_NotSupported = -8024,
	/**
	 * Unable to verify the certificate chain.
	 */
	id3BiosealError_UnableToVerifyCertificateChain = -8025,
	/**
	 * Need to verify the BioSeal.
	 */
	id3BiosealError_NeedToVerify = -8026,
	/**
	 * No signature found.
	 */
	id3BiosealError_NoSignatureFound = -8027,
	/**
	 * This function is not implemented.
	 */
	id3BiosealError_FunctionNotImplemented = -8028,
	/**
	 * No certificate found.
	 */
	id3BiosealError_NoCertificateFound = -8029,
	/**
	 * Internal SSL error.
	 */
	id3BiosealError_InternalSslError = -8030,
	/**
	 * Unable to parse the given URL.
	 */
	id3BiosealError_UrlParsingError = -8031,
	/**
	 * Document issuing country not supported.
	 */
	id3BiosealError_UnsupportedDocumentIssuingCountry = -8032,
	/**
	 * Incorrect issuing agency code (IAC) in code prefix.
	 */
	id3BiosealError_WrongPrefix = -8033,
	/**
	 * TODO
	 */
	id3BiosealError_DuplicateManifestField = -8034,
} id3BiosealError;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetBiosealErrorString(int value);
ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetBiosealErrorMessage(int value);

#ifdef __cplusplus
}
#endif

#endif
