//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealLogItemType_h
#define _id3BiosealLogItemType_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the log item types.
 */
typedef enum id3BiosealLogItemType {
	/**
	 * The log item is an undefined.
	 */
	id3BiosealLogItemType_Undefined = 0,
	/**
	 * The log item is an information.
	 */
	id3BiosealLogItemType_Information = 1,
	/**
	 * The log item is a warning.
	 */
	id3BiosealLogItemType_Warning = 2,
	/**
	 * The log item is an error.
	 */
	id3BiosealLogItemType_Error = 3,
	/**
	 * The log item is for debug only.
	 */
	id3BiosealLogItemType_Debug = 4,
} id3BiosealLogItemType;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetLogItemTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
