//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealVerificationResult_h
#define _id3BiosealVerificationResult_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Contains data for VerificationResult
 */
typedef struct id3BiosealVerificationResult {
	/**
	 * Indicates whether the certification chain has been verified.
	 */
    int CertificationChainVerified;
	/**
	 * Indicates whether the governance that issued the VDS is valid.
	 */
    int GovernanceValid;
	/**
	 * Indicates whether the LoTL governance that issued the VDS is valid.
	 */
    int LotlGovernanceValid;
	/**
	 * Indicates whether the TSL governance that issued the VDS is valid.
	 */
    int TslGovernanceValid;
	/**
	 * Indicates whether the manifest governance that issued the VDS is valid.
	 */
    int ManifestGovernanceValid;
	/**
	 * Indicates whether the VDS is still valid, ie. it has not expired.
	 */
    int VdsNotExpired;
	/**
	 * Indicates whether the signature of the VDS has been verified.
	 */
    int VdsSignatureVerified;
	/**
	 * Indicates whether the CA certificate has been verified.
	 */
    int CaCertificateVerified;
	/**
	 * Indicates whether the signing certificate was legitimately authorized to sign the VDS.
	 */
    int SigningCertificateUsageAuthorized;
} id3BiosealVerificationResult;

#ifdef __cplusplus
}
#endif

#endif
