//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3BiosealVisibilityCondition_h
#define _id3BiosealVisibilityCondition_h

#include <id3Bioseal/id3BiosealExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the visibility conditions.
 * Note: The optional visibility condition extension indicates under which condition the presentation view or certain field in the presentation view should be displayed.
 */
typedef enum id3BiosealVisibilityCondition {
	/**
	 * The presentation view or the specified field shall always be displayed. This is the default value.
	 */
	id3BiosealVisibilityCondition_Always = 0,
	/**
	 * The BioSeal signature must be valid.
	 */
	id3BiosealVisibilityCondition_SignatureValidated = 1,
	/**
	 * The signature must be valid and the bioseal must not be expired.
	 */
	id3BiosealVisibilityCondition_NotExpired = 2,
	/**
	 * The above conditions must be met, and user authentication must be successful.
	 */
	id3BiosealVisibilityCondition_UserAuthenticated = 3,
	/**
	 *  The presentation view or the specified field must never be displayed. In this case, the application must not inject the data into the presentation view.
	 */
	id3BiosealVisibilityCondition_Never = 4,
} id3BiosealVisibilityCondition;

ID3BIOSEAL_C_API const char * ID3_CDECL id3Bioseal_GetVisibilityConditionString(int value);

#ifdef __cplusplus
}
#endif

#endif
