//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#pragma once
#include <stdexcept>
#include <string>
#include <id3Bioseal/id3BiosealError.h>

namespace id3BiosealCppWrapper
{
/**
    * @class BiosealException
    * @brief This class represents errors that can occur during Bioseal library execution.
    *
**/
class BiosealException : public std::runtime_error
{
public:
    explicit BiosealException(const std::string &message, int errorCode = -1)
        : std::runtime_error(
            message + ": " + id3Bioseal_GetBiosealErrorMessage(errorCode) +
            " (" + id3Bioseal_GetBiosealErrorString(errorCode) + ", " + std::to_string(errorCode) + ")"
        ),
        m_errorCode(errorCode)
    {}

    int getErrorCode() const {
        return m_errorCode;
    }

private:
    int m_errorCode;
};

/**
 * @brief Helper function to check the return code of SDK functions and throw on error.
 * @param code The error code returned by an id3 C-API function.
 */
inline void check_error(int code) {
    if (code != id3BiosealError_Success) {
        throw BiosealException("An id3 Bioseal error occurred", code);
    }
}
};