//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#pragma once
#include <id3BiosealCppWrapper/id3BiosealException.hpp>
#include <id3Bioseal/id3BiosealLibrary.h>

namespace id3BiosealCppWrapper
{

/**
 * Provides essential methods for initializing the SDK and accessing version information.
 */
class BiosealLibrary
{
private:
    // Disallow creating an instance of this object
    BiosealLibrary() {}

public:
    // public getters and setters
    // public methods
    /**
    * Retrieves the library version as a 'X.Y.Z' formatted string.
    * @param libraryVersion [out] A string that identifies the library version.
    * @exception BiosealException An error has occured during Bioseal library execution.
    * @retval A string that identifies the library version.
    */
    static void getVersion(std::string & libraryVersion) {
        int libraryVersionSize = -1;
        auto err = id3BiosealLibrary_GetVersion(libraryVersion.data(), &libraryVersionSize);
        if (err == (int)id3BiosealError_InsufficientBuffer) {
            libraryVersion.resize(libraryVersionSize);
            err = id3BiosealLibrary_GetVersion(libraryVersion.data(), &libraryVersionSize);
            if (err == 0) { libraryVersion.resize(libraryVersionSize); }
        }
        check_error(err);
    }

    /**
    * Retrieves the library version as a 'X.Y.Z' formatted string.
    * @exception BiosealException An error has occured during Bioseal library execution.
    * @retval A string that identifies the library version.
    */
    static std::string getVersion() {
        std::string library_version;
        getVersion(library_version);
        return library_version;
    }

    /**
    * Retrieves the library version as a structure.
    * @exception BiosealException An error has occured during Bioseal library execution.
    * @retval The version.
    */
    static id3BiosealLibVersion getVersionEx() {
        id3BiosealLibVersion version;
        check_error(id3BiosealLibrary_GetVersionEx(&version));
        return version;
    }

};
};