//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#pragma once
#include <type_traits>
#include <cstdint>

namespace id3BiosealCppWrapper
{
using bool_size_t = std::integral_constant<std::size_t, sizeof(bool)>;
using bool_storage_t =
    std::conditional_t<bool_size_t::value == 1, uint8_t,
        std::conditional_t<bool_size_t::value == 2, uint16_t,
            std::conditional_t<bool_size_t::value == 4, uint32_t,
                std::conditional_t<bool_size_t::value == 8, uint64_t, void>>>>;
static_assert(!std::is_void<bool_storage_t>::value, "Unsupported sizeof(bool) on this platform (not 1,2,4 or 8 bytes)");
};