# id3 Bioseal SDK

Version 1.52.0

(c) Copyright id3 Technologies 2025. All Rights Reserved.

## Overview

id3 Bioseal SDK is a powerful cross-platform toolkit designed to secure and verify documents using digital seals. It enables developers to create applications that can verify the authenticity and integrity of both digital and printed documents through embedded cryptographic signatures, typically in the form of QR codes.

## Key Features

* **Document Protection & Verification**
  * Secure documents with cryptographic digital signatures
  * Verify document authenticity and integrity
  * Detect any tampering or modifications

* **Built on Standards**
  * Based on the Visible Digital Seal (VDS) framework
  * Compliant with ISO 22376 for digital seals
  * Ensures global interoperability and future-proofing

* **Trust Management**
  * Robust digital signature verification
  * Support for trusted issuers and certificate authorities
  * Automated chain of trust validation

* **Cross-Platform Support**
  * Compatible with Windows, Linux, Android, macOS, and iOS
  * Optimized for various hardware configurations
  * Available for multiple programming languages (C, C#, Java, Python, Dart, Swift...)

## Package Contents

This SDK package includes:

* `bin/` - Dynamic libraries for different platforms
* `dart/` - Dart wrapper source code
* `docs/` - Comprehensive API reference and Developer Guide
* `dotnet/` - .NET wrapper library
* `include/` - C header files
* `java/` - Java JAR archive
* `python/` - Python package
* `samples/` - Example implementations in C, C#, and Android
* `tools/` - BioSeal verification command-line interface tools

## Getting Started

### Prerequisites

* **Windows/Linux/macOS**: Modern operating system with standard development tools
* **Android/iOS**: Latest SDK and development environment

### Quick Start

1. Include the appropriate library for your platform in your project
2. Initialize the Bioseal SDK with your license
3. Use the provided APIs to verify document seals
4. Handle verification results and errors appropriately

For detailed implementation guides and API references, please refer to the documentation in the `docs/` directory.

## Support

For technical issues with our products or services, please contact: support@id3.eu
Our technical team is available during business hours.

## License and Attribution

This software is protected by copyright and includes open-source third-party libraries. For complete license information, please see the `docs/3rdParty` directory.

## Documentation

Comprehensive documentation, including API references and usage examples, is available in the `docs` directory. For the latest updates and detailed developer guides, please refer to the official documentation.

---
*Bioseal SDK - Securing documents with trusted digital signatures*