/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentInfo;
import eu.id3.document.DocumentNative;
import eu.id3.document.DocumentOrientation;
import eu.id3.document.PointList;
import java.io.Serializable;

public class DetectedDocument
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DetectedDocument() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = DetectedDocument.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public DetectedDocument(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DetectedDocument.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public DetectedDocument clone() throws DocumentException {
        DetectedDocument clone = new DetectedDocument();
        int err = DetectedDocument.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public PointList getBounds() throws DocumentException {
        PointList bounds = new PointList();
        int err = DetectedDocument.nGetBounds(this.handle, bounds.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return bounds;
    }

    public void setBounds(PointList bounds) throws DocumentException {
        int err = DetectedDocument.nSetBounds(this.handle, bounds.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public int getConfidence() throws DocumentException {
        int[] confidenceArray = new int[1];
        int err = DetectedDocument.nGetConfidence(this.handle, confidenceArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return confidenceArray[0];
    }

    public DocumentInfo getInfo() throws DocumentException {
        DocumentInfo info = new DocumentInfo();
        int err = DetectedDocument.nGetInfo(this.handle, info.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return info;
    }

    public DocumentOrientation getOrientation() throws DocumentException {
        DocumentOrientation orientation = new DocumentOrientation();
        int err = DetectedDocument.nGetOrientation(this.handle, orientation);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return orientation;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetBounds(long var0, long var2);

    static native int nSetBounds(long var0, long var2);

    static native int nGetConfidence(long var0, int[] var2);

    static native int nGetInfo(long var0, long var2);

    static native int nGetOrientation(long var0, DocumentOrientation var2);

    static {
        DocumentNative.loadLibraries();
    }
}

