/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentImage;
import eu.id3.document.DocumentNative;
import eu.id3.document.HologramAuthenticationResultList;
import java.io.Serializable;
import java.nio.charset.Charset;

public class DocumentAuthenticator
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DocumentAuthenticator() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = DocumentAuthenticator.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public DocumentAuthenticator(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DocumentAuthenticator.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public String getDocumentName() throws DocumentException {
        byte[] documentName = null;
        int[] documentNameSizeArray = new int[]{-1};
        int err = DocumentAuthenticator.nGetDocumentName(this.handle, documentName, documentNameSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            documentName = new byte[documentNameSizeArray[0]];
            err = DocumentAuthenticator.nGetDocumentName(this.handle, documentName, documentNameSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(documentName, 0, documentNameSizeArray[0], Charset.defaultCharset());
    }

    public void setDocumentName(String documentName) throws DocumentException {
        int err = DocumentAuthenticator.nSetDocumentName(this.handle, documentName);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public int getTemporalWindowSize() throws DocumentException {
        int[] temporalWindowSizeArray = new int[1];
        int err = DocumentAuthenticator.nGetTemporalWindowSize(this.handle, temporalWindowSizeArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return temporalWindowSizeArray[0];
    }

    public void setTemporalWindowSize(int temporalWindowSize) throws DocumentException {
        int err = DocumentAuthenticator.nSetTemporalWindowSize(this.handle, temporalWindowSize);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void appendFrame(DocumentImage image) throws DocumentException {
        int err = DocumentAuthenticator.nAppendFrame(this.handle, image.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public HologramAuthenticationResultList authenticateHolograms() throws DocumentException {
        HologramAuthenticationResultList scoreList = new HologramAuthenticationResultList();
        int err = DocumentAuthenticator.nAuthenticateHolograms(this.handle, scoreList.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return scoreList;
    }

    public boolean isFull() throws DocumentException {
        boolean[] resultArray = new boolean[1];
        int err = DocumentAuthenticator.nIsFull(this.handle, resultArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return resultArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetDocumentName(long var0, byte[] var2, int[] var3);

    static native int nSetDocumentName(long var0, String var2);

    static native int nGetTemporalWindowSize(long var0, int[] var2);

    static native int nSetTemporalWindowSize(long var0, int var2);

    static native int nAppendFrame(long var0, long var2);

    static native int nAuthenticateHolograms(long var0, long var2);

    static native int nIsFull(long var0, boolean[] var2);

    static {
        DocumentNative.loadLibraries();
    }
}

