/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DetectedDocument;
import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentImage;
import eu.id3.document.DocumentModel;
import eu.id3.document.DocumentNative;
import eu.id3.document.ProcessingUnit;
import eu.id3.document.Rectangle;
import java.io.Serializable;

public class DocumentDetector
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DocumentDetector() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = DocumentDetector.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public DocumentDetector(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DocumentDetector.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getConfidenceThreshold() throws DocumentException {
        int[] confidenceThresholdArray = new int[1];
        int err = DocumentDetector.nGetConfidenceThreshold(this.handle, confidenceThresholdArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return confidenceThresholdArray[0];
    }

    public void setConfidenceThreshold(int confidenceThreshold) throws DocumentException {
        int err = DocumentDetector.nSetConfidenceThreshold(this.handle, confidenceThreshold);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public float getDocumentWidthRatio() throws DocumentException {
        float[] documentWidthRatioArray = new float[1];
        int err = DocumentDetector.nGetDocumentWidthRatio(this.handle, documentWidthRatioArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return documentWidthRatioArray[0];
    }

    public void setDocumentWidthRatio(float documentWidthRatio) throws DocumentException {
        int err = DocumentDetector.nSetDocumentWidthRatio(this.handle, documentWidthRatio);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public DocumentModel getModel() throws DocumentException {
        int[] modelArray = new int[1];
        int err = DocumentDetector.nGetModel(this.handle, modelArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return DocumentModel.fromValue(modelArray[0]);
    }

    public void setModel(DocumentModel model) throws DocumentException {
        int err = DocumentDetector.nSetModel(this.handle, model.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public ProcessingUnit getProcessingUnit() throws DocumentException {
        int[] processingUnitArray = new int[1];
        int err = DocumentDetector.nGetProcessingUnit(this.handle, processingUnitArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return ProcessingUnit.fromValue(processingUnitArray[0]);
    }

    public void setProcessingUnit(ProcessingUnit processingUnit) throws DocumentException {
        int err = DocumentDetector.nSetProcessingUnit(this.handle, processingUnit.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public int getThreadCount() throws DocumentException {
        int[] threadCountArray = new int[1];
        int err = DocumentDetector.nGetThreadCount(this.handle, threadCountArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return threadCountArray[0];
    }

    public void setThreadCount(int threadCount) throws DocumentException {
        int err = DocumentDetector.nSetThreadCount(this.handle, threadCount);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public DocumentImage alignDocument(DocumentImage sourceImage, DetectedDocument detectedDocument) throws DocumentException {
        DocumentImage alignedImage = new DocumentImage();
        int err = DocumentDetector.nAlignDocument(this.handle, sourceImage.getHandle(), detectedDocument.getHandle(), alignedImage.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return alignedImage;
    }

    public DetectedDocument detectDocument(DocumentImage image, Rectangle detectionZone) throws DocumentException {
        DetectedDocument detectedDocument = new DetectedDocument();
        int err = DocumentDetector.nDetectDocument(this.handle, image.getHandle(), detectionZone, detectedDocument.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return detectedDocument;
    }

    public DetectedDocument detectDocumentByName(DocumentImage image, String documentName, Rectangle detectionZone) throws DocumentException {
        DetectedDocument detectedDocument = new DetectedDocument();
        int err = DocumentDetector.nDetectDocumentByName(this.handle, image.getHandle(), documentName, detectionZone, detectedDocument.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return detectedDocument;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetConfidenceThreshold(long var0, int[] var2);

    static native int nSetConfidenceThreshold(long var0, int var2);

    static native int nGetDocumentWidthRatio(long var0, float[] var2);

    static native int nSetDocumentWidthRatio(long var0, float var2);

    static native int nGetModel(long var0, int[] var2);

    static native int nSetModel(long var0, int var2);

    static native int nGetProcessingUnit(long var0, int[] var2);

    static native int nSetProcessingUnit(long var0, int var2);

    static native int nGetThreadCount(long var0, int[] var2);

    static native int nSetThreadCount(long var0, int var2);

    static native int nAlignDocument(long var0, long var2, long var4, long var6);

    static native int nDetectDocument(long var0, long var2, Rectangle var4, long var5);

    static native int nDetectDocumentByName(long var0, long var2, String var4, Rectangle var5, long var6);

    static {
        DocumentNative.loadLibraries();
    }
}

