/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

public enum DocumentError {
    SUCCESS(0),
    INSUFFICIENT_BUFFER(-1),
    OBJECT_DOES_NOT_EXIST(-2),
    BASE(-11000),
    MINIMUM(-11999),
    INVALID_HANDLE(-11001),
    INVALID_PARAMETER(-11002),
    INVALID_PIXEL_FORMAT(-11004),
    INVALID_MODEL_PATH(-11008),
    INVALID_DOCUMENT_TEMPLATE_PATH(-11009),
    UNLOADED_MODEL(-11020),
    UNLOADED_DOCUMENT_TEMPLATE(-11021),
    UNKNOWN_ANNOTATION(-11022),
    INVALID_DOCUMENT_TEMPLATE_FORMAT(-11023),
    INSUFFICIENT_FRAME_NUMBER(-11030),
    BACKEND_ERROR(-11039),
    INFERENCE_BACKEND_ERROR(-11040),
    PROCESSING_UNIT_UNAVAILABLE(-11041),
    FUNCTION_NOT_IMPLEMENTED(-11056);

    private final int value;

    private DocumentError(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DocumentError fromValue(int value) {
        DocumentError[] types;
        for (DocumentError type : types = DocumentError.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Unable to find the specified enum value for " + value);
    }

    String getMessage() {
        return DocumentError.nGetDocumentErrorMessage(this.value);
    }

    static native String nGetDocumentErrorMessage(int var0);
}

