/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import eu.id3.document.ImageBuffer;
import eu.id3.document.ImageFormat;
import eu.id3.document.PixelFormat;
import eu.id3.document.Rectangle;
import java.io.Serializable;

public class DocumentImage
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DocumentImage() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = DocumentImage.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public DocumentImage(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DocumentImage.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public DocumentImage clone() throws DocumentException {
        DocumentImage clone = new DocumentImage();
        int err = DocumentImage.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public byte[] getData() throws DocumentException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = DocumentImage.nGetData(this.handle, data, dataSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = DocumentImage.nGetData(this.handle, data, dataSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return data;
    }

    public int getHeight() throws DocumentException {
        int[] heightArray = new int[1];
        int err = DocumentImage.nGetHeight(this.handle, heightArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return heightArray[0];
    }

    public int getPixelDepth() throws DocumentException {
        int[] pixelDepthArray = new int[1];
        int err = DocumentImage.nGetPixelDepth(this.handle, pixelDepthArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return pixelDepthArray[0];
    }

    public PixelFormat getPixelFormat() throws DocumentException {
        int[] pixelFormatArray = new int[1];
        int err = DocumentImage.nGetPixelFormat(this.handle, pixelFormatArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return PixelFormat.fromValue(pixelFormatArray[0]);
    }

    public int getStride() throws DocumentException {
        int[] strideArray = new int[1];
        int err = DocumentImage.nGetStride(this.handle, strideArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return strideArray[0];
    }

    public int getWidth() throws DocumentException {
        int[] widthArray = new int[1];
        int err = DocumentImage.nGetWidth(this.handle, widthArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return widthArray[0];
    }

    public float compare(DocumentImage cmpDocumentImage) throws DocumentException {
        float[] resultArray = new float[1];
        int err = DocumentImage.nCompare(this.handle, cmpDocumentImage.getHandle(), resultArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return resultArray[0];
    }

    public void correctGamma(int contrast, int brightness, float gamma) throws DocumentException {
        int err = DocumentImage.nCorrectGamma(this.handle, contrast, brightness, gamma);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public DocumentImage crop(int left, int top, int width, int height) throws DocumentException {
        DocumentImage documentImageCrop = new DocumentImage();
        int err = DocumentImage.nCrop(this.handle, left, top, width, height, documentImageCrop.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return documentImageCrop;
    }

    public float downscale(int maxSize) throws DocumentException {
        float[] scaleRatioArray = new float[1];
        int err = DocumentImage.nDownscale(this.handle, maxSize, scaleRatioArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return scaleRatioArray[0];
    }

    public float downscaleTo(DocumentImage dstDocumentImage, int maxSize) throws DocumentException {
        float[] scaleRatioArray = new float[1];
        int err = DocumentImage.nDownscaleTo(this.handle, dstDocumentImage.getHandle(), maxSize, scaleRatioArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return scaleRatioArray[0];
    }

    public DocumentImage extractRoi(Rectangle bounds) throws DocumentException {
        DocumentImage documentImageRoi = new DocumentImage();
        int err = DocumentImage.nExtractRoi(this.handle, bounds, documentImageRoi.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return documentImageRoi;
    }

    public DocumentImage extractRoiWithColor(Rectangle bounds, int colorRed, int colorGreen, int colorBlue) throws DocumentException {
        DocumentImage documentImageRoi = new DocumentImage();
        int err = DocumentImage.nExtractRoiWithColor(this.handle, bounds, colorRed, colorGreen, colorBlue, documentImageRoi.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return documentImageRoi;
    }

    public void flip(boolean flipHorizontally, boolean flipVertically) throws DocumentException {
        int err = DocumentImage.nFlip(this.handle, flipHorizontally, flipVertically);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void flipTo(boolean flipHorizontally, boolean flipVertically, DocumentImage dstDocumentImage) throws DocumentException {
        int err = DocumentImage.nFlipTo(this.handle, flipHorizontally, flipVertically, dstDocumentImage.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static DocumentImage fromBuffer(byte[] data, PixelFormat pixelFormat) throws DocumentException {
        DocumentImage documentImage = new DocumentImage();
        int err = DocumentImage.nFromBuffer(documentImage.getHandle(), data, pixelFormat.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return documentImage;
    }

    public static DocumentImage fromFile(String filepath, PixelFormat pixelFormat) throws DocumentException {
        DocumentImage documentImage = new DocumentImage();
        int err = DocumentImage.nFromFile(documentImage.getHandle(), filepath, pixelFormat.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return documentImage;
    }

    public static DocumentImage fromRawBuffer(byte[] pixels, int width, int height, int stride, PixelFormat srcPixelFormat, PixelFormat dstPixelFormat) throws DocumentException {
        DocumentImage documentImage = new DocumentImage();
        int err = DocumentImage.nFromRawBuffer(documentImage.getHandle(), pixels, width, height, stride, srcPixelFormat.getValue(), dstPixelFormat.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return documentImage;
    }

    public static DocumentImage fromYuvPlanes(byte[] yPlane, byte[] uPlane, byte[] vPlane, int yWidth, int yHeight, int uvPixelStride, int uvRowStride, PixelFormat dstPixelFormat) throws DocumentException {
        DocumentImage documentImage = new DocumentImage();
        int err = DocumentImage.nFromYuvPlanes(documentImage.getHandle(), yPlane, uPlane, vPlane, yWidth, yHeight, uvPixelStride, uvRowStride, dstPixelFormat.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return documentImage;
    }

    public void pad(int top, int left, int bottom, int right, int colorRed, int colorGreen, int colorBlue) throws DocumentException {
        int err = DocumentImage.nPad(this.handle, top, left, bottom, right, colorRed, colorGreen, colorBlue);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void reallocate(int width, int height, PixelFormat pixelFormat) throws DocumentException {
        int err = DocumentImage.nReallocate(this.handle, width, height, pixelFormat.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void resize(int width, int height) throws DocumentException {
        int err = DocumentImage.nResize(this.handle, width, height);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void resizeTo(int width, int height, DocumentImage dstDocumentImage) throws DocumentException {
        int err = DocumentImage.nResizeTo(this.handle, width, height, dstDocumentImage.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void rotate(int angle) throws DocumentException {
        int err = DocumentImage.nRotate(this.handle, angle);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void rotateTo(int angle, DocumentImage dstDocumentImage) throws DocumentException {
        int err = DocumentImage.nRotateTo(this.handle, angle, dstDocumentImage.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public byte[] toBuffer(ImageFormat documentImageFormat, float compressionLevel) throws DocumentException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = DocumentImage.nToBuffer(this.handle, documentImageFormat.getValue(), compressionLevel, data, dataSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = DocumentImage.nToBuffer(this.handle, documentImageFormat.getValue(), compressionLevel, data, dataSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return data;
    }

    public void toBufferObject(ImageFormat documentImageFormat, float compressionLevel, ImageBuffer buffer) throws DocumentException {
        int err = DocumentImage.nToBufferObject(this.handle, documentImageFormat.getValue(), compressionLevel, buffer.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void toFile(String filepath, float compressionLevel) throws DocumentException {
        int err = DocumentImage.nToFile(this.handle, filepath, compressionLevel);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void toRawBuffer(PixelFormat pixelFormat, ImageBuffer buffer) throws DocumentException {
        int err = DocumentImage.nToRawBuffer(this.handle, pixelFormat.getValue(), buffer.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void transpose() throws DocumentException {
        int err = DocumentImage.nTranspose(this.handle);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetData(long var0, byte[] var2, int[] var3);

    static native int nGetHeight(long var0, int[] var2);

    static native int nGetPixelDepth(long var0, int[] var2);

    static native int nGetPixelFormat(long var0, int[] var2);

    static native int nGetStride(long var0, int[] var2);

    static native int nGetWidth(long var0, int[] var2);

    static native int nCompare(long var0, long var2, float[] var4);

    static native int nCorrectGamma(long var0, int var2, int var3, float var4);

    static native int nCrop(long var0, int var2, int var3, int var4, int var5, long var6);

    static native int nDownscale(long var0, int var2, float[] var3);

    static native int nDownscaleTo(long var0, long var2, int var4, float[] var5);

    static native int nExtractRoi(long var0, Rectangle var2, long var3);

    static native int nExtractRoiWithColor(long var0, Rectangle var2, int var3, int var4, int var5, long var6);

    static native int nFlip(long var0, boolean var2, boolean var3);

    static native int nFlipTo(long var0, boolean var2, boolean var3, long var4);

    static native int nFromBuffer(long var0, byte[] var2, int var3);

    static native int nFromFile(long var0, String var2, int var3);

    static native int nFromRawBuffer(long var0, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    static native int nFromYuvPlanes(long var0, byte[] var2, byte[] var3, byte[] var4, int var5, int var6, int var7, int var8, int var9);

    static native int nPad(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    static native int nReallocate(long var0, int var2, int var3, int var4);

    static native int nResize(long var0, int var2, int var3);

    static native int nResizeTo(long var0, int var2, int var3, long var4);

    static native int nRotate(long var0, int var2);

    static native int nRotateTo(long var0, int var2, long var3);

    static native int nToBuffer(long var0, int var2, float var3, byte[] var4, int[] var5);

    static native int nToBufferObject(long var0, int var2, float var3, long var4);

    static native int nToFile(long var0, String var2, float var3);

    static native int nToRawBuffer(long var0, int var2, long var3);

    static native int nTranspose(long var0);

    static {
        DocumentNative.loadLibraries();
    }
}

