/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentCategory;
import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentFormat;
import eu.id3.document.DocumentNative;
import eu.id3.document.MrzType;
import java.io.Serializable;
import java.nio.charset.Charset;

public class DocumentInfo
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DocumentInfo() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = DocumentInfo.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public DocumentInfo(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DocumentInfo.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public DocumentInfo clone() throws DocumentException {
        DocumentInfo clone = new DocumentInfo();
        int err = DocumentInfo.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public DocumentCategory getCategory() throws DocumentException {
        int[] categoryArray = new int[1];
        int err = DocumentInfo.nGetCategory(this.handle, categoryArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return DocumentCategory.fromValue(categoryArray[0]);
    }

    public String getCountry() throws DocumentException {
        byte[] country = null;
        int[] countrySizeArray = new int[]{-1};
        int err = DocumentInfo.nGetCountry(this.handle, country, countrySizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            country = new byte[countrySizeArray[0]];
            err = DocumentInfo.nGetCountry(this.handle, country, countrySizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(country, 0, countrySizeArray[0], Charset.defaultCharset());
    }

    public String getDate() throws DocumentException {
        byte[] date = null;
        int[] dateSizeArray = new int[]{-1};
        int err = DocumentInfo.nGetDate(this.handle, date, dateSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            date = new byte[dateSizeArray[0]];
            err = DocumentInfo.nGetDate(this.handle, date, dateSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(date, 0, dateSizeArray[0], Charset.defaultCharset());
    }

    public String getDescription() throws DocumentException {
        byte[] description = null;
        int[] descriptionSizeArray = new int[]{-1};
        int err = DocumentInfo.nGetDescription(this.handle, description, descriptionSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            description = new byte[descriptionSizeArray[0]];
            err = DocumentInfo.nGetDescription(this.handle, description, descriptionSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(description, 0, descriptionSizeArray[0], Charset.defaultCharset());
    }

    public DocumentFormat getFormat() throws DocumentException {
        int[] formatArray = new int[1];
        int err = DocumentInfo.nGetFormat(this.handle, formatArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return DocumentFormat.fromValue(formatArray[0]);
    }

    public String getIdentifier() throws DocumentException {
        byte[] identifier = null;
        int[] identifierSizeArray = new int[]{-1};
        int err = DocumentInfo.nGetIdentifier(this.handle, identifier, identifierSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            identifier = new byte[identifierSizeArray[0]];
            err = DocumentInfo.nGetIdentifier(this.handle, identifier, identifierSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(identifier, 0, identifierSizeArray[0], Charset.defaultCharset());
    }

    public MrzType getMrzType() throws DocumentException {
        int[] mrzTypeArray = new int[1];
        int err = DocumentInfo.nGetMrzType(this.handle, mrzTypeArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return MrzType.fromValue(mrzTypeArray[0]);
    }

    public String getName() throws DocumentException {
        byte[] name = null;
        int[] nameSizeArray = new int[]{-1};
        int err = DocumentInfo.nGetName(this.handle, name, nameSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            name = new byte[nameSizeArray[0]];
            err = DocumentInfo.nGetName(this.handle, name, nameSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(name, 0, nameSizeArray[0], Charset.defaultCharset());
    }

    public int getPageNumber() throws DocumentException {
        int[] pageNumberArray = new int[1];
        int err = DocumentInfo.nGetPageNumber(this.handle, pageNumberArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return pageNumberArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetCategory(long var0, int[] var2);

    static native int nGetCountry(long var0, byte[] var2, int[] var3);

    static native int nGetDate(long var0, byte[] var2, int[] var3);

    static native int nGetDescription(long var0, byte[] var2, int[] var3);

    static native int nGetFormat(long var0, int[] var2);

    static native int nGetIdentifier(long var0, byte[] var2, int[] var3);

    static native int nGetMrzType(long var0, int[] var2);

    static native int nGetName(long var0, byte[] var2, int[] var3);

    static native int nGetPageNumber(long var0, int[] var2);

    static {
        DocumentNative.loadLibraries();
    }
}

