/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentInfo;
import eu.id3.document.DocumentNative;
import eu.id3.document.StringList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DocumentInfoDictionary
implements AutoCloseable,
Serializable,
Iterable<DocumentInfo> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DocumentInfoDictionary() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = DocumentInfoDictionary.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public DocumentInfoDictionary(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DocumentInfoDictionary.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public DocumentInfoDictionary clone() throws DocumentException {
        DocumentInfoDictionary clone = new DocumentInfoDictionary();
        int err = DocumentInfoDictionary.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public StringList getKeys() throws DocumentException {
        StringList keys = new StringList();
        int err = DocumentInfoDictionary.nGetKeys(this.handle, keys.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return keys;
    }

    public void clear() throws DocumentException {
        int err = DocumentInfoDictionary.nClear(this.handle);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void add(String key, DocumentInfo documentInfoItem) throws DocumentException {
        int err = DocumentInfoDictionary.nAdd(this.handle, key, documentInfoItem.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public DocumentInfo get(String key) throws DocumentException {
        DocumentInfo documentInfoItem = new DocumentInfo();
        int err = DocumentInfoDictionary.nGet(this.handle, key, documentInfoItem.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return documentInfoItem;
    }

    public void set(String key, DocumentInfo documentInfoItem) throws DocumentException {
        int err = DocumentInfoDictionary.nSet(this.handle, key, documentInfoItem.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public int getCount() throws DocumentException {
        int[] countArray = new int[1];
        int err = DocumentInfoDictionary.nGetCount(this.handle, countArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return countArray[0];
    }

    public boolean containsKey(String key) throws DocumentException {
        boolean[] resultArray = new boolean[1];
        int err = DocumentInfoDictionary.nContainsKey(this.handle, key, resultArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return resultArray[0];
    }

    public void remove(String key) throws DocumentException {
        int err = DocumentInfoDictionary.nRemove(this.handle, key);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetKeys(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, String var2, long var3);

    static native int nGet(long var0, String var2, long var3);

    static native int nSet(long var0, String var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nContainsKey(long var0, String var2, boolean[] var3);

    static native int nRemove(long var0, String var2);

    @Override
    public Iterator<DocumentInfo> iterator() {
        return new Iterator<DocumentInfo>(){
            private int index = 0;
            private final StringList keyList = DocumentInfoDictionary.this.getKeys();
            private final int size = DocumentInfoDictionary.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public DocumentInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DocumentInfoDictionary.this.get(this.keyList.get(this.index++));
            }
        };
    }

    static {
        DocumentNative.loadLibraries();
    }
}

