/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentModel;
import eu.id3.document.DocumentNative;
import eu.id3.document.LibVersion;
import eu.id3.document.ProcessingUnit;
import java.nio.charset.Charset;

public class DocumentLibrary {
    public static String getVersion() throws DocumentException {
        byte[] libraryVersion = new byte[8];
        int[] libraryVersionSizeArray = new int[]{8};
        int err = DocumentLibrary.nGetVersion(libraryVersion, libraryVersionSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            libraryVersion = new byte[libraryVersionSizeArray[0]];
            err = DocumentLibrary.nGetVersion(libraryVersion, libraryVersionSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(libraryVersion, 0, libraryVersionSizeArray[0], Charset.defaultCharset());
    }

    public static LibVersion getVersionEx() throws DocumentException {
        LibVersion version = new LibVersion();
        int err = DocumentLibrary.nGetVersionEx(version);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return version;
    }

    public static void loadDocumentTemplate(String path) throws DocumentException {
        int err = DocumentLibrary.nLoadDocumentTemplate(path);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static void loadDocumentTemplateBuffer(byte[] buffer) throws DocumentException {
        int err = DocumentLibrary.nLoadDocumentTemplateBuffer(buffer);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static void loadModel(String modelPath, DocumentModel documentModel, ProcessingUnit processingUnit) throws DocumentException {
        int err = DocumentLibrary.nLoadModel(modelPath, documentModel.getValue(), processingUnit.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static void loadModelBuffer(byte[] modelBuffer, DocumentModel documentModel, ProcessingUnit processingUnit) throws DocumentException {
        int err = DocumentLibrary.nLoadModelBuffer(modelBuffer, documentModel.getValue(), processingUnit.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static void unloadDocumentTemplate(String documentName) throws DocumentException {
        int err = DocumentLibrary.nUnloadDocumentTemplate(documentName);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static void unloadModel(DocumentModel documentModel, ProcessingUnit processingUnit) throws DocumentException {
        int err = DocumentLibrary.nUnloadModel(documentModel.getValue(), processingUnit.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    static native int nGetVersion(byte[] var0, int[] var1);

    static native int nGetVersionEx(LibVersion var0);

    static native int nLoadDocumentTemplate(String var0);

    static native int nLoadDocumentTemplateBuffer(byte[] var0);

    static native int nLoadModel(String var0, int var1, int var2);

    static native int nLoadModelBuffer(byte[] var0, int var1, int var2);

    static native int nUnloadDocumentTemplate(String var0);

    static native int nUnloadModel(int var0, int var1);

    static {
        DocumentNative.loadLibraries();
    }
}

