/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import eu.id3.document.LicenseHardwareCodeType;
import eu.id3.document.LicenseType;
import java.nio.charset.Charset;
import java.util.Arrays;

public class DocumentLicense {
    public static void activate(String hardwareCode, String login, String password, String productReference, String commentary, String path) throws DocumentException {
        int err = DocumentLicense.nActivate(hardwareCode, login, password, productReference, commentary, path);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static void activateActivationKey(String hardwareCode, String activationKey, String commentary, String path) throws DocumentException {
        int err = DocumentLicense.nActivateActivationKey(hardwareCode, activationKey, commentary, path);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static byte[] activateActivationKeyBuffer(String hardwareCode, String activationKey, String commentary) throws DocumentException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = DocumentLicense.nActivateActivationKeyBuffer(hardwareCode, activationKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == DocumentError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = DocumentLicense.nActivateActivationKeyBuffer(hardwareCode, activationKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return licenseFileBuffer;
    }

    public static byte[] activateBuffer(String hardwareCode, String login, String password, String productReference, String commentary) throws DocumentException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = DocumentLicense.nActivateBuffer(hardwareCode, login, password, productReference, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == DocumentError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = DocumentLicense.nActivateBuffer(hardwareCode, login, password, productReference, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return licenseFileBuffer;
    }

    public static void activateSerialKey(String hardwareCode, String serialKey, String commentary, String path) throws DocumentException {
        int err = DocumentLicense.nActivateSerialKey(hardwareCode, serialKey, commentary, path);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static byte[] activateSerialKeyBuffer(String hardwareCode, String serialKey, String commentary) throws DocumentException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = DocumentLicense.nActivateSerialKeyBuffer(hardwareCode, serialKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == DocumentError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = DocumentLicense.nActivateSerialKeyBuffer(hardwareCode, serialKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return licenseFileBuffer;
    }

    public static void checkLicense(String licensePath) throws DocumentException {
        int err = DocumentLicense.nCheckLicense(licensePath);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static void checkLicenseBuffer(byte[] licenseData) throws DocumentException {
        int err = DocumentLicense.nCheckLicenseBuffer(licenseData);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static byte[] checkLicenseBufferWithCard(byte[] licenseData) throws DocumentException {
        byte[] challengeR1 = new byte[16];
        int[] challengeR1SizeArray = new int[]{16};
        int err = DocumentLicense.nCheckLicenseBufferWithCard(licenseData, challengeR1, challengeR1SizeArray);
        if (err == DocumentError.SUCCESS.getValue()) {
            return Arrays.copyOf(challengeR1, challengeR1SizeArray[0]);
        }
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            challengeR1 = new byte[challengeR1SizeArray[0]];
            err = DocumentLicense.nCheckLicenseBufferWithCard(licenseData, challengeR1, challengeR1SizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return challengeR1;
    }

    public static byte[] checkLicenseWithCard(String licensePath) throws DocumentException {
        byte[] challengeR1 = new byte[16];
        int[] challengeR1SizeArray = new int[]{16};
        int err = DocumentLicense.nCheckLicenseWithCard(licensePath, challengeR1, challengeR1SizeArray);
        if (err == DocumentError.SUCCESS.getValue()) {
            return Arrays.copyOf(challengeR1, challengeR1SizeArray[0]);
        }
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            challengeR1 = new byte[challengeR1SizeArray[0]];
            err = DocumentLicense.nCheckLicenseWithCard(licensePath, challengeR1, challengeR1SizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return challengeR1;
    }

    public static void checkModule(String moduleName) throws DocumentException {
        int err = DocumentLicense.nCheckModule(moduleName);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static void finalizeCheckLicenseWithCard(byte[] cryptogram) throws DocumentException {
        int err = DocumentLicense.nFinalizeCheckLicenseWithCard(cryptogram);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static String getExpiryDate() throws DocumentException {
        byte[] expiryDate = new byte[256];
        int[] expiryDateSizeArray = new int[]{256};
        int err = DocumentLicense.nGetExpiryDate(expiryDate, expiryDateSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            expiryDate = new byte[expiryDateSizeArray[0]];
            err = DocumentLicense.nGetExpiryDate(expiryDate, expiryDateSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(expiryDate, 0, expiryDateSizeArray[0], Charset.defaultCharset());
    }

    public static String getExternalDriveHardwareCode(LicenseHardwareCodeType hardwareCodeType, String externalDrivePath) throws DocumentException {
        byte[] code = new byte[256];
        int[] codeSizeArray = new int[]{256};
        int err = DocumentLicense.nGetExternalDriveHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray, externalDrivePath);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            code = new byte[codeSizeArray[0]];
            err = DocumentLicense.nGetExternalDriveHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray, externalDrivePath);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(code, 0, codeSizeArray[0], Charset.defaultCharset());
    }

    public static String getHostHardwareCode(LicenseHardwareCodeType hardwareCodeType) throws DocumentException {
        byte[] code = new byte[256];
        int[] codeSizeArray = new int[]{256};
        int err = DocumentLicense.nGetHostHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            code = new byte[codeSizeArray[0]];
            err = DocumentLicense.nGetHostHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(code, 0, codeSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseFileHardwareCode() throws DocumentException {
        byte[] licenseFileHardwareCode = new byte[256];
        int[] licenseFileHardwareCodeSizeArray = new int[]{256};
        int err = DocumentLicense.nGetLicenseFileHardwareCode(licenseFileHardwareCode, licenseFileHardwareCodeSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileHardwareCode = new byte[licenseFileHardwareCodeSizeArray[0]];
            err = DocumentLicense.nGetLicenseFileHardwareCode(licenseFileHardwareCode, licenseFileHardwareCodeSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(licenseFileHardwareCode, 0, licenseFileHardwareCodeSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseFileSerial() throws DocumentException {
        byte[] licenseFileSerial = new byte[256];
        int[] licenseFileSerialSizeArray = new int[]{256};
        int err = DocumentLicense.nGetLicenseFileSerial(licenseFileSerial, licenseFileSerialSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileSerial = new byte[licenseFileSerialSizeArray[0]];
            err = DocumentLicense.nGetLicenseFileSerial(licenseFileSerial, licenseFileSerialSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(licenseFileSerial, 0, licenseFileSerialSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseName() throws DocumentException {
        byte[] licenseName = new byte[256];
        int[] licenseNameSizeArray = new int[]{256};
        int err = DocumentLicense.nGetLicenseName(licenseName, licenseNameSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            licenseName = new byte[licenseNameSizeArray[0]];
            err = DocumentLicense.nGetLicenseName(licenseName, licenseNameSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(licenseName, 0, licenseNameSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseOwner() throws DocumentException {
        byte[] licenseOwner = new byte[256];
        int[] licenseOwnerSizeArray = new int[]{256};
        int err = DocumentLicense.nGetLicenseOwner(licenseOwner, licenseOwnerSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            licenseOwner = new byte[licenseOwnerSizeArray[0]];
            err = DocumentLicense.nGetLicenseOwner(licenseOwner, licenseOwnerSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(licenseOwner, 0, licenseOwnerSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicensePath() throws DocumentException {
        byte[] licensePath = new byte[256];
        int[] licensePathSizeArray = new int[]{256};
        int err = DocumentLicense.nGetLicensePath(licensePath, licensePathSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            licensePath = new byte[licensePathSizeArray[0]];
            err = DocumentLicense.nGetLicensePath(licensePath, licensePathSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(licensePath, 0, licensePathSizeArray[0], Charset.defaultCharset());
    }

    public static LicenseType getLicenseType() throws DocumentException {
        int[] documentLicenseTypeArray = new int[1];
        int err = DocumentLicense.nGetLicenseType(documentLicenseTypeArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return LicenseType.fromValue(documentLicenseTypeArray[0]);
    }

    public static int getModuleCount() throws DocumentException {
        int[] countArray = new int[1];
        int err = DocumentLicense.nGetModuleCount(countArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return countArray[0];
    }

    public static String getModuleName(int index) throws DocumentException {
        byte[] name = new byte[256];
        int[] nameSizeArray = new int[]{256};
        int err = DocumentLicense.nGetModuleName(index, name, nameSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            name = new byte[nameSizeArray[0]];
            err = DocumentLicense.nGetModuleName(index, name, nameSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(name, 0, nameSizeArray[0], Charset.defaultCharset());
    }

    public static int getModuleValue(String name) throws DocumentException {
        int[] valueArray = new int[1];
        int err = DocumentLicense.nGetModuleValue(name, valueArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return valueArray[0];
    }

    public static String getProductReference() throws DocumentException {
        byte[] productReference = new byte[256];
        int[] productReferenceSizeArray = new int[]{256};
        int err = DocumentLicense.nGetProductReference(productReference, productReferenceSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            productReference = new byte[productReferenceSizeArray[0]];
            err = DocumentLicense.nGetProductReference(productReference, productReferenceSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(productReference, 0, productReferenceSizeArray[0], Charset.defaultCharset());
    }

    public static int getRemainingDays() throws DocumentException {
        int[] remainingDaysArray = new int[1];
        int err = DocumentLicense.nGetRemainingDays(remainingDaysArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return remainingDaysArray[0];
    }

    public static void reactivate(String hardwareCode, String productReference, String path) throws DocumentException {
        int err = DocumentLicense.nReactivate(hardwareCode, productReference, path);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public static byte[] reactivateBuffer(String hardwareCode, String productReference) throws DocumentException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = DocumentLicense.nReactivateBuffer(hardwareCode, productReference, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == DocumentError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = DocumentLicense.nReactivateBuffer(hardwareCode, productReference, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return licenseFileBuffer;
    }

    static native int nActivate(String var0, String var1, String var2, String var3, String var4, String var5);

    static native int nActivateActivationKey(String var0, String var1, String var2, String var3);

    static native int nActivateActivationKeyBuffer(String var0, String var1, String var2, byte[] var3, int[] var4);

    static native int nActivateBuffer(String var0, String var1, String var2, String var3, String var4, byte[] var5, int[] var6);

    static native int nActivateSerialKey(String var0, String var1, String var2, String var3);

    static native int nActivateSerialKeyBuffer(String var0, String var1, String var2, byte[] var3, int[] var4);

    static native int nCheckLicense(String var0);

    static native int nCheckLicenseBuffer(byte[] var0);

    static native int nCheckLicenseBufferWithCard(byte[] var0, byte[] var1, int[] var2);

    static native int nCheckLicenseWithCard(String var0, byte[] var1, int[] var2);

    static native int nCheckModule(String var0);

    static native int nFinalizeCheckLicenseWithCard(byte[] var0);

    static native int nGetExpiryDate(byte[] var0, int[] var1);

    static native int nGetExternalDriveHardwareCode(int var0, byte[] var1, int[] var2, String var3);

    static native int nGetHostHardwareCode(int var0, byte[] var1, int[] var2);

    static native int nGetLicenseFileHardwareCode(byte[] var0, int[] var1);

    static native int nGetLicenseFileSerial(byte[] var0, int[] var1);

    static native int nGetLicenseName(byte[] var0, int[] var1);

    static native int nGetLicenseOwner(byte[] var0, int[] var1);

    static native int nGetLicensePath(byte[] var0, int[] var1);

    static native int nGetLicenseType(int[] var0);

    static native int nGetModuleCount(int[] var0);

    static native int nGetModuleName(int var0, byte[] var1, int[] var2);

    static native int nGetModuleValue(String var0, int[] var1);

    static native int nGetProductReference(byte[] var0, int[] var1);

    static native int nGetRemainingDays(int[] var0);

    static native int nReactivate(String var0, String var1, String var2);

    static native int nReactivateBuffer(String var0, String var1, byte[] var2, int[] var3);

    static {
        DocumentNative.loadLibraries();
    }
}

