/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentImage;
import eu.id3.document.DocumentNative;
import eu.id3.document.TextField;
import eu.id3.document.TextFieldList;
import java.io.Serializable;

public class DocumentReader
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DocumentReader() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = DocumentReader.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public DocumentReader(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DocumentReader.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getThreadCount() throws DocumentException {
        int[] threadCountArray = new int[1];
        int err = DocumentReader.nGetThreadCount(this.handle, threadCountArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return threadCountArray[0];
    }

    public void setThreadCount(int threadCount) throws DocumentException {
        int err = DocumentReader.nSetThreadCount(this.handle, threadCount);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public DocumentImage extractFace(DocumentImage image, String documentName) throws DocumentException {
        DocumentImage croppedFace = new DocumentImage();
        int err = DocumentReader.nExtractFace(this.handle, image.getHandle(), documentName, croppedFace.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return croppedFace;
    }

    public TextFieldList readDocument(DocumentImage image, String documentName) throws DocumentException {
        TextFieldList readTexts = new TextFieldList();
        int err = DocumentReader.nReadDocument(this.handle, image.getHandle(), documentName, readTexts.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return readTexts;
    }

    public TextField readField(DocumentImage image, String documentName, String fieldName) throws DocumentException {
        TextField readText = new TextField();
        int err = DocumentReader.nReadField(this.handle, image.getHandle(), documentName, fieldName, readText.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return readText;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetThreadCount(long var0, int[] var2);

    static native int nSetThreadCount(long var0, int var2);

    static native int nExtractFace(long var0, long var2, String var4, long var5);

    static native int nReadDocument(long var0, long var2, String var4, long var5);

    static native int nReadField(long var0, long var2, String var4, String var5, long var6);

    static {
        DocumentNative.loadLibraries();
    }
}

