/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import eu.id3.document.Rectangle;
import java.io.Serializable;
import java.nio.charset.Charset;

public class HologramAuthenticationResult
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public HologramAuthenticationResult() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = HologramAuthenticationResult.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public HologramAuthenticationResult(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            HologramAuthenticationResult.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public HologramAuthenticationResult clone() throws DocumentException {
        HologramAuthenticationResult clone = new HologramAuthenticationResult();
        int err = HologramAuthenticationResult.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public Rectangle getBounds() throws DocumentException {
        Rectangle bounds = new Rectangle();
        int err = HologramAuthenticationResult.nGetBounds(this.handle, bounds);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return bounds;
    }

    public float getCorrelationScore() throws DocumentException {
        float[] correlationScoreArray = new float[1];
        int err = HologramAuthenticationResult.nGetCorrelationScore(this.handle, correlationScoreArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return correlationScoreArray[0];
    }

    public String getHologramName() throws DocumentException {
        byte[] hologramName = null;
        int[] hologramNameSizeArray = new int[]{-1};
        int err = HologramAuthenticationResult.nGetHologramName(this.handle, hologramName, hologramNameSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            hologramName = new byte[hologramNameSizeArray[0]];
            err = HologramAuthenticationResult.nGetHologramName(this.handle, hologramName, hologramNameSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(hologramName, 0, hologramNameSizeArray[0], Charset.defaultCharset());
    }

    public float getVariationScore() throws DocumentException {
        float[] variationScoreArray = new float[1];
        int err = HologramAuthenticationResult.nGetVariationScore(this.handle, variationScoreArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return variationScoreArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetBounds(long var0, Rectangle var2);

    static native int nGetCorrelationScore(long var0, float[] var2);

    static native int nGetHologramName(long var0, byte[] var2, int[] var3);

    static native int nGetVariationScore(long var0, float[] var2);

    static {
        DocumentNative.loadLibraries();
    }
}

