/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import eu.id3.document.HologramAuthenticationResult;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class HologramAuthenticationResultList
implements AutoCloseable,
Serializable,
Iterable<HologramAuthenticationResult> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public HologramAuthenticationResultList() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = HologramAuthenticationResultList.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public HologramAuthenticationResultList(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            HologramAuthenticationResultList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public HologramAuthenticationResultList clone() throws DocumentException {
        HologramAuthenticationResultList clone = new HologramAuthenticationResultList();
        int err = HologramAuthenticationResultList.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public void clear() throws DocumentException {
        int err = HologramAuthenticationResultList.nClear(this.handle);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void add(HologramAuthenticationResult hologramAuthenticationResultItem) throws DocumentException {
        int err = HologramAuthenticationResultList.nAdd(this.handle, hologramAuthenticationResultItem.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public HologramAuthenticationResult get(int index) throws DocumentException {
        HologramAuthenticationResult hologramAuthenticationResultItem = new HologramAuthenticationResult();
        int err = HologramAuthenticationResultList.nGet(this.handle, index, hologramAuthenticationResultItem.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return hologramAuthenticationResultItem;
    }

    public void set(int index, HologramAuthenticationResult hologramAuthenticationResultItem) throws DocumentException {
        int err = HologramAuthenticationResultList.nSet(this.handle, index, hologramAuthenticationResultItem.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public int getCount() throws DocumentException {
        int[] countArray = new int[1];
        int err = HologramAuthenticationResultList.nGetCount(this.handle, countArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return countArray[0];
    }

    public void removeAt(int index) throws DocumentException {
        int err = HologramAuthenticationResultList.nRemoveAt(this.handle, index);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void resize(int newSize) throws DocumentException {
        int err = HologramAuthenticationResultList.nResize(this.handle, newSize);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, long var2);

    static native int nGet(long var0, int var2, long var3);

    static native int nSet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nRemoveAt(long var0, int var2);

    static native int nResize(long var0, int var2);

    @Override
    public Iterator<HologramAuthenticationResult> iterator() {
        return new Iterator<HologramAuthenticationResult>(){
            private int index = 0;
            private final int size = HologramAuthenticationResultList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public HologramAuthenticationResult next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return HologramAuthenticationResultList.this.get(this.index++);
            }
        };
    }

    static {
        DocumentNative.loadLibraries();
    }
}

