/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import java.io.Serializable;

public class ImageBuffer
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public ImageBuffer() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = ImageBuffer.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public ImageBuffer(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            ImageBuffer.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public ImageBuffer clone() throws DocumentException {
        ImageBuffer clone = new ImageBuffer();
        int err = ImageBuffer.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public byte[] getData() throws DocumentException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = ImageBuffer.nGetData(this.handle, data, dataSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = ImageBuffer.nGetData(this.handle, data, dataSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return data;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetData(long var0, byte[] var2, int[] var3);

    static {
        DocumentNative.loadLibraries();
    }
}

