/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

public enum ImageError {
    SUCCESS(0),
    INSUFFICIENT_BUFFER(-1),
    OBJECT_DOES_NOT_EXIST(-2),
    BASE(-3000),
    MINIMUM(-3999),
    INVALID_HANDLE(-3001),
    INVALID_PARAMETER(-3002),
    IMAGE_SIZE_MISMATCH(-3003),
    PIXEL_FORMAT_MISMATCH(-3004),
    KEY_ALREADY_EXISTS(-3005),
    KEY_NOT_FOUND(-3006),
    INVALID_PIXEL_FORMAT(-3007),
    PYTHON_MODULE(-3008),
    FUNCTION_NOT_IMPLEMENTED(-3009),
    BACKEND_ERROR(-3010);

    private final int value;

    private ImageError(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ImageError fromValue(int value) {
        ImageError[] types;
        for (ImageError type : types = ImageError.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Unable to find the specified enum value for " + value);
    }

    String getMessage() {
        return ImageError.nGetDocumentErrorMessage(this.value);
    }

    static native String nGetDocumentErrorMessage(int var0);
}

