/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentImage;
import eu.id3.document.DocumentModel;
import eu.id3.document.DocumentNative;
import eu.id3.document.MrzReadingResult;
import eu.id3.document.ProcessingUnit;
import java.io.Serializable;

public class MrzReader
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public MrzReader() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = MrzReader.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public MrzReader(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            MrzReader.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getBinarizationMethod() throws DocumentException {
        int[] binarizationMethodArray = new int[1];
        int err = MrzReader.nGetBinarizationMethod(this.handle, binarizationMethodArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return binarizationMethodArray[0];
    }

    public void setBinarizationMethod(int binarizationMethod) throws DocumentException {
        int err = MrzReader.nSetBinarizationMethod(this.handle, binarizationMethod);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public DocumentModel getModel() throws DocumentException {
        int[] modelArray = new int[1];
        int err = MrzReader.nGetModel(this.handle, modelArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return DocumentModel.fromValue(modelArray[0]);
    }

    public void setModel(DocumentModel model) throws DocumentException {
        int err = MrzReader.nSetModel(this.handle, model.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public ProcessingUnit getProcessingUnit() throws DocumentException {
        int[] processingUnitArray = new int[1];
        int err = MrzReader.nGetProcessingUnit(this.handle, processingUnitArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return ProcessingUnit.fromValue(processingUnitArray[0]);
    }

    public void setProcessingUnit(ProcessingUnit processingUnit) throws DocumentException {
        int err = MrzReader.nSetProcessingUnit(this.handle, processingUnit.getValue());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public int getThreadCount() throws DocumentException {
        int[] threadCountArray = new int[1];
        int err = MrzReader.nGetThreadCount(this.handle, threadCountArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return threadCountArray[0];
    }

    public void setThreadCount(int threadCount) throws DocumentException {
        int err = MrzReader.nSetThreadCount(this.handle, threadCount);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public MrzReadingResult readMrz(DocumentImage image) throws DocumentException {
        MrzReadingResult result = new MrzReadingResult();
        int err = MrzReader.nReadMrz(this.handle, image.getHandle(), result.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return result;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetBinarizationMethod(long var0, int[] var2);

    static native int nSetBinarizationMethod(long var0, int var2);

    static native int nGetModel(long var0, int[] var2);

    static native int nSetModel(long var0, int var2);

    static native int nGetProcessingUnit(long var0, int[] var2);

    static native int nSetProcessingUnit(long var0, int var2);

    static native int nGetThreadCount(long var0, int[] var2);

    static native int nSetThreadCount(long var0, int var2);

    static native int nReadMrz(long var0, long var2, long var4);

    static {
        DocumentNative.loadLibraries();
    }
}

