/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import eu.id3.document.MrzType;
import eu.id3.document.PointList;
import java.io.Serializable;
import java.nio.charset.Charset;

public class MrzReadingResult
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public MrzReadingResult() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = MrzReadingResult.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public MrzReadingResult(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            MrzReadingResult.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public MrzReadingResult clone() throws DocumentException {
        MrzReadingResult clone = new MrzReadingResult();
        int err = MrzReadingResult.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public PointList getBounds() throws DocumentException {
        PointList bounds = new PointList();
        int err = MrzReadingResult.nGetBounds(this.handle, bounds.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return bounds;
    }

    public float getConfidence() throws DocumentException {
        float[] confidenceArray = new float[1];
        int err = MrzReadingResult.nGetConfidence(this.handle, confidenceArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return confidenceArray[0];
    }

    public String getMrz() throws DocumentException {
        byte[] mrz = null;
        int[] mrzSizeArray = new int[]{-1};
        int err = MrzReadingResult.nGetMrz(this.handle, mrz, mrzSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            mrz = new byte[mrzSizeArray[0]];
            err = MrzReadingResult.nGetMrz(this.handle, mrz, mrzSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(mrz, 0, mrzSizeArray[0], Charset.defaultCharset());
    }

    public MrzType getMrzType() throws DocumentException {
        int[] mrzTypeArray = new int[1];
        int err = MrzReadingResult.nGetMrzType(this.handle, mrzTypeArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return MrzType.fromValue(mrzTypeArray[0]);
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetBounds(long var0, long var2);

    static native int nGetConfidence(long var0, float[] var2);

    static native int nGetMrz(long var0, byte[] var2, int[] var3);

    static native int nGetMrzType(long var0, int[] var2);

    static {
        DocumentNative.loadLibraries();
    }
}

