/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

public enum PixelFormat {
    UNDEFINED(0),
    GRAYSCALE_8_BITS(10),
    GRAYSCALE_16_BITS(20),
    GRAYSCALE_FLOAT(25),
    BGR_24_BITS(30),
    RGB_24_BITS(31),
    BGRA(32),
    RGBA(33),
    NV12(40),
    I420(41),
    YUY2(42),
    YV12(43);

    private final int value;

    private PixelFormat(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static PixelFormat fromValue(int value) {
        PixelFormat[] types;
        for (PixelFormat type : types = PixelFormat.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Unable to find the specified enum value for " + value);
    }

    String getMessage() {
        return PixelFormat.nGetDocumentErrorMessage(this.value);
    }

    static native String nGetDocumentErrorMessage(int var0);
}

