/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

public enum ProcessingUnit {
    CPU(0),
    GPU(1),
    OPENCL(2),
    CUDA(3),
    METAL(4),
    VULKAN(5);

    private final int value;

    private ProcessingUnit(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ProcessingUnit fromValue(int value) {
        ProcessingUnit[] types;
        for (ProcessingUnit type : types = ProcessingUnit.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Unable to find the specified enum value for " + value);
    }

    String getMessage() {
        return ProcessingUnit.nGetDocumentErrorMessage(this.value);
    }

    static native String nGetDocumentErrorMessage(int var0);
}

