/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import eu.id3.document.StringList;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringDict
implements AutoCloseable,
Serializable,
Iterable<String> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public StringDict() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = StringDict.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public StringDict(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            StringDict.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public StringDict clone() throws DocumentException {
        StringDict clone = new StringDict();
        int err = StringDict.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public StringList getKeys() throws DocumentException {
        StringList keys = new StringList();
        int err = StringDict.nGetKeys(this.handle, keys.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return keys;
    }

    public void clear() throws DocumentException {
        int err = StringDict.nClear(this.handle);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void add(String key, String item) throws DocumentException {
        int err = StringDict.nAdd(this.handle, key, item);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public String get(String key) throws DocumentException {
        byte[] item = null;
        int[] itemSizeArray = new int[]{-1};
        int err = StringDict.nGet(this.handle, key, item, itemSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            item = new byte[itemSizeArray[0]];
            err = StringDict.nGet(this.handle, key, item, itemSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(item, 0, itemSizeArray[0], Charset.defaultCharset());
    }

    public void set(String key, String item) throws DocumentException {
        int err = StringDict.nSet(this.handle, key, item);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public int getCount() throws DocumentException {
        int[] countArray = new int[1];
        int err = StringDict.nGetCount(this.handle, countArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return countArray[0];
    }

    public boolean containsKey(String key) throws DocumentException {
        boolean[] resultArray = new boolean[1];
        int err = StringDict.nContainsKey(this.handle, key, resultArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return resultArray[0];
    }

    public void remove(String key) throws DocumentException {
        int err = StringDict.nRemove(this.handle, key);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetKeys(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, String var2, String var3);

    static native int nGet(long var0, String var2, byte[] var3, int[] var4);

    static native int nSet(long var0, String var2, String var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nContainsKey(long var0, String var2, boolean[] var3);

    static native int nRemove(long var0, String var2);

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;
            private final StringList keyList = StringDict.this.getKeys();
            private final int size = StringDict.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StringDict.this.get(this.keyList.get(this.index++));
            }
        };
    }

    static {
        DocumentNative.loadLibraries();
    }
}

