/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringList
implements AutoCloseable,
Serializable,
Iterable<String> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public StringList() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = StringList.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public StringList(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            StringList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public StringList clone() throws DocumentException {
        StringList clone = new StringList();
        int err = StringList.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public void clear() throws DocumentException {
        int err = StringList.nClear(this.handle);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void add(String item) throws DocumentException {
        int err = StringList.nAdd(this.handle, item);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public String get(int index) throws DocumentException {
        byte[] item = null;
        int[] itemSizeArray = new int[]{-1};
        int err = StringList.nGet(this.handle, index, item, itemSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            item = new byte[itemSizeArray[0]];
            err = StringList.nGet(this.handle, index, item, itemSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(item, 0, itemSizeArray[0], Charset.defaultCharset());
    }

    public void set(int index, String item) throws DocumentException {
        int err = StringList.nSet(this.handle, index, item);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public int getCount() throws DocumentException {
        int[] countArray = new int[1];
        int err = StringList.nGetCount(this.handle, countArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return countArray[0];
    }

    public void removeAt(int index) throws DocumentException {
        int err = StringList.nRemoveAt(this.handle, index);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void resize(int newSize) throws DocumentException {
        int err = StringList.nResize(this.handle, newSize);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, String var2);

    static native int nGet(long var0, int var2, byte[] var3, int[] var4);

    static native int nSet(long var0, int var2, String var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nRemoveAt(long var0, int var2);

    static native int nResize(long var0, int var2);

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int index = 0;
            private final int size = StringList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return StringList.this.get(this.index++);
            }
        };
    }

    static {
        DocumentNative.loadLibraries();
    }
}

