/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import eu.id3.document.Rectangle;
import java.io.Serializable;
import java.nio.charset.Charset;

public class TextField
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public TextField() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = TextField.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public TextField(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            TextField.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public TextField clone() throws DocumentException {
        TextField clone = new TextField();
        int err = TextField.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public Rectangle getBounds() throws DocumentException {
        Rectangle bounds = new Rectangle();
        int err = TextField.nGetBounds(this.handle, bounds);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return bounds;
    }

    public float getConfidence() throws DocumentException {
        float[] confidenceArray = new float[1];
        int err = TextField.nGetConfidence(this.handle, confidenceArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return confidenceArray[0];
    }

    public String getName() throws DocumentException {
        byte[] name = null;
        int[] nameSizeArray = new int[]{-1};
        int err = TextField.nGetName(this.handle, name, nameSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            name = new byte[nameSizeArray[0]];
            err = TextField.nGetName(this.handle, name, nameSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(name, 0, nameSizeArray[0], Charset.defaultCharset());
    }

    public String getValue() throws DocumentException {
        byte[] value = null;
        int[] valueSizeArray = new int[]{-1};
        int err = TextField.nGetValue(this.handle, value, valueSizeArray);
        if (err == DocumentError.INSUFFICIENT_BUFFER.getValue()) {
            value = new byte[valueSizeArray[0]];
            err = TextField.nGetValue(this.handle, value, valueSizeArray);
        }
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return new String(value, 0, valueSizeArray[0], Charset.defaultCharset());
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetBounds(long var0, Rectangle var2);

    static native int nGetConfidence(long var0, float[] var2);

    static native int nGetName(long var0, byte[] var2, int[] var3);

    static native int nGetValue(long var0, byte[] var2, int[] var3);

    static {
        DocumentNative.loadLibraries();
    }
}

