/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.document;

import eu.id3.document.DocumentError;
import eu.id3.document.DocumentException;
import eu.id3.document.DocumentNative;
import eu.id3.document.TextField;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TextFieldList
implements AutoCloseable,
Serializable,
Iterable<TextField> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public TextFieldList() throws DocumentException {
        long[] pHandle = new long[]{0L};
        int err = TextFieldList.nInitialize(pHandle);
        if (err != 0) {
            throw new DocumentException(err);
        }
        this.handle = pHandle[0];
    }

    public TextFieldList(long handle) throws DocumentException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            TextFieldList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public TextFieldList clone() throws DocumentException {
        TextFieldList clone = new TextFieldList();
        int err = TextFieldList.nCopyTo(this.handle, clone.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public void clear() throws DocumentException {
        int err = TextFieldList.nClear(this.handle);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void add(TextField textFieldItem) throws DocumentException {
        int err = TextFieldList.nAdd(this.handle, textFieldItem.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public TextField get(int index) throws DocumentException {
        TextField textFieldItem = new TextField();
        int err = TextFieldList.nGet(this.handle, index, textFieldItem.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return textFieldItem;
    }

    public void set(int index, TextField textFieldItem) throws DocumentException {
        int err = TextFieldList.nSet(this.handle, index, textFieldItem.getHandle());
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public int getCount() throws DocumentException {
        int[] countArray = new int[1];
        int err = TextFieldList.nGetCount(this.handle, countArray);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
        return countArray[0];
    }

    public void removeAt(int index) throws DocumentException {
        int err = TextFieldList.nRemoveAt(this.handle, index);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    public void resize(int newSize) throws DocumentException {
        int err = TextFieldList.nResize(this.handle, newSize);
        if (err != DocumentError.SUCCESS.getValue()) {
            throw new DocumentException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, long var2);

    static native int nGet(long var0, int var2, long var3);

    static native int nSet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nRemoveAt(long var0, int var2);

    static native int nResize(long var0, int var2);

    @Override
    public Iterator<TextField> iterator() {
        return new Iterator<TextField>(){
            private int index = 0;
            private final int size = TextFieldList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public TextField next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return TextFieldList.this.get(this.index++);
            }
        };
    }

    static {
        DocumentNative.loadLibraries();
    }
}

