//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentCategory_h
#define _id3DocumentCategory_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates document categories.
 */
typedef enum id3DocumentCategory {
	/**
	 * Unknown document category.
	 */
	id3DocumentCategory_Unknown = 0,
	/**
	 * Passport
	 */
	id3DocumentCategory_A = 1,
	/**
	 * Identity card
	 */
	id3DocumentCategory_B = 2,
	/**
	 * Visa
	 */
	id3DocumentCategory_C = 3,
	/**
	 * Stamp
	 */
	id3DocumentCategory_D = 4,
	/**
	 * Entry paper
	 */
	id3DocumentCategory_E = 5,
	/**
	 * Driving licence
	 */
	id3DocumentCategory_F = 6,
	/**
	 * Vehicle licence/ log book
	 */
	id3DocumentCategory_G = 7,
	/**
	 * Residence-related document
	 */
	id3DocumentCategory_H = 8,
	/**
	 * Seafarers' identity document
	 */
	id3DocumentCategory_I = 9,
	/**
	 * Travel document issued to non-nationals
	 */
	id3DocumentCategory_J = 10,
	/**
	 * Train driving licence
	 */
	id3DocumentCategory_K = 11,
	/**
	 * Crew member certificate / pilot's licence
	 */
	id3DocumentCategory_L = 12,
	/**
	 * Certificate for operators of pleasure crafts / captain's licence
	 */
	id3DocumentCategory_M = 13,
	/**
	 * Civil status/ other official document
	 */
	id3DocumentCategory_P = 14,
	/**
	 * Special authorisation card
	 */
	id3DocumentCategory_S = 15,
	/**
	 * Travel document
	 */
	id3DocumentCategory_T = 16,
	/**
	 * Authorisation to represent a company
	 */
	id3DocumentCategory_V = 17,
	/**
	 * Work permit
	 */
	id3DocumentCategory_W = 18,
	/**
	 * Other document
	 */
	id3DocumentCategory_X = 19,
} id3DocumentCategory;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetDocumentCategoryString(int value);

#ifdef __cplusplus
}
#endif

#endif
