//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentError_h
#define _id3DocumentError_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates possible error codes.
 */
typedef enum id3DocumentError {
	/**
	 * No error.
	 */
	id3DocumentError_Success = 0,
	/**
	 * The given buffer is too small.
	 */
	id3DocumentError_InsufficientBuffer = -1,
	/**
	 * The requested object does not exist; a 'null' should be returned if possible.
	 */
	id3DocumentError_ObjectDoesNotExist = -2,
	/**
	 * Base error code of the Document module.
	 */
	id3DocumentError_Base = -11000,
	/**
	 * Minimum error code of the Document module.
	 */
	id3DocumentError_Minimum = -11999,
	/**
	 * The handle is invalid.
	 */
	id3DocumentError_InvalidHandle = -11001,
	/**
	 * The parameter is invalid.
	 */
	id3DocumentError_InvalidParameter = -11002,
	/**
	 * The image pixel format is invalid.
	 */
	id3DocumentError_InvalidPixelFormat = -11004,
	/**
	 * The model could not be found in the given directory path.
	 */
	id3DocumentError_InvalidModelPath = -11008,
	/**
	 * The document template could not be found at the given path.
	 */
	id3DocumentError_InvalidDocumentTemplatePath = -11009,
	/**
	 * The model which is required for this operation has not been  loaded.
	 */
	id3DocumentError_UnloadedModel = -11020,
	/**
	 * The document template required for this operation has not been loaded.
	 */
	id3DocumentError_UnloadedDocumentTemplate = -11021,
	/**
	 * The required element is not present in the document annotation.
	 */
	id3DocumentError_UnknownAnnotation = -11022,
	/**
	 * The format of the document template is invalid.
	 */
	id3DocumentError_InvalidDocumentTemplateFormat = -11023,
	/**
	 * The frame buffer is not full, and computation is not allowed.
	 */
	id3DocumentError_InsufficientFrameNumber = -11030,
	/**
	 * One of our computation backends failed for unknown reasons.
	 */
	id3DocumentError_BackendError = -11039,
	/**
	 * The inference backend failed to infer, probably due to inconsistent input.
	 */
	id3DocumentError_InferenceBackendError = -11040,
	/**
	 * The requested processing unit is not available in this build.
	 */
	id3DocumentError_ProcessingUnitUnavailable = -11041,
	/**
	 * This function is not implemented.
	 */
	id3DocumentError_FunctionNotImplemented = -11056,
} id3DocumentError;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetDocumentErrorString(int value);
ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetDocumentErrorMessage(int value);

#ifdef __cplusplus
}
#endif

#endif
