//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentImageFormat_h
#define _id3DocumentImageFormat_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates supported image formats.
 */
typedef enum id3DocumentImageFormat {
	/**
	 * BMP.
	 */
	id3DocumentImageFormat_Bmp = 0,
	/**
	 * JPEG.
	 */
	id3DocumentImageFormat_Jpeg = 2,
	/**
	 * PNG.
	 */
	id3DocumentImageFormat_Png = 13,
	/**
	 * Tiff.
	 */
	id3DocumentImageFormat_Tiff = 18,
	/**
	 * JPEG 2000.
	 */
	id3DocumentImageFormat_Jpeg2000 = 30,
	/**
	 * WEBP.
	 */
	id3DocumentImageFormat_Webp = 31,
	/**
	 * Raw.
	 */
	id3DocumentImageFormat_Raw = 34,
} id3DocumentImageFormat;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetImageFormatString(int value);

#ifdef __cplusplus
}
#endif

#endif
