//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentLicenseError_h
#define _id3DocumentLicenseError_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the error codes related to license management.
 */
typedef enum id3DocumentLicenseError {
	/**
	 * No error.
	 */
	id3DocumentLicenseError_Success = 0,
	/**
	 * The given buffer is too small.
	 */
	id3DocumentLicenseError_InsufficientBuffer = -1,
	/**
	 * The requested object does not exist; a 'null' should be returned if possible.
	 */
	id3DocumentLicenseError_ObjectDoesNotExist = -2,
	/**
	 * Base error code of the License module.
	 */
	id3DocumentLicenseError_Base = -100,
	/**
	 * Minimum error code of the License module.
	 */
	id3DocumentLicenseError_Minimum = -999,
	/**
	 * The handle is invalid.
	 */
	id3DocumentLicenseError_InvalidHandle = -101,
	/**
	 * One of the parameters is incorrect.
	 */
	id3DocumentLicenseError_InvalidParameter = -102,
	/**
	 * No license was found.
	 */
	id3DocumentLicenseError_LicenseNotFound = -103,
	/**
	 * License is not valid or a required module is not licensed.
	 */
	id3DocumentLicenseError_InvalidLicense = -104,
	/**
	 * The license has expired.
	 */
	id3DocumentLicenseError_ExpiredLicense = -105,
	/**
	 * Installation code does not match hardware ID.
	 */
	id3DocumentLicenseError_InvalidHardwareId = -106,
	/**
	 * The license is already fulfilled by another user (or computer).
	 */
	id3DocumentLicenseError_AlreadyFulfilled = -107,
	/**
	 * A required module is not licensed or the usage limit has been reached.
	 */
	id3DocumentLicenseError_ModuleError = -108,
	/**
	 * The license file cannot be accessed in write mode.
	 */
	id3DocumentLicenseError_WriteError = -109,
	/**
	 * The number of available licenses has been reached. There isn't any available license remaining.
	 */
	id3DocumentLicenseError_InsufficientLicenseCredits = -110,
	/**
	 * The serial is invalid.
	 */
	id3DocumentLicenseError_InvalidSerial = -111,
	/**
	 * Invalid login or password.
	 */
	id3DocumentLicenseError_InvalidCredentials = -112,
	/**
	 * The license is revoked or does not exist anymore.
	 */
	id3DocumentLicenseError_RevokedLicense = -113,
	/**
	 * The license is blocked after a predefined period.
	 */
	id3DocumentLicenseError_BlockedLicense = -114,
	/**
	 * The license server is currently unreachable.
	 */
	id3DocumentLicenseError_UnreachableServer = -115,
	/**
	 * An unexpected error happened.
	 */
	id3DocumentLicenseError_LicenseOtherError = -116,
	/**
	 * No license file was provided.
	 */
	id3DocumentLicenseError_MissingFile = -117,
	/**
	 * This device is not compatible with id3 licensing system.
	 */
	id3DocumentLicenseError_DeviceNotCompatible = -118,
} id3DocumentLicenseError;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetLicenseErrorString(int value);
ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetLicenseErrorMessage(int value);

#ifdef __cplusplus
}
#endif

#endif
