//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentProcessingUnit_h
#define _id3DocumentProcessingUnit_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates processing units.
 */
typedef enum id3DocumentProcessingUnit {
	/**
	 * CPU.
	 */
	id3DocumentProcessingUnit_Cpu = 0,
	/**
	 * GPU (automatic backend selection).
	 */
	id3DocumentProcessingUnit_Gpu = 1,
	/**
	 * OpenCL Backend.
	 */
	id3DocumentProcessingUnit_Opencl = 2,
	/**
	 * CUDA Backend.
	 */
	id3DocumentProcessingUnit_Cuda = 3,
	/**
	 * Metal Backend.
	 */
	id3DocumentProcessingUnit_Metal = 4,
	/**
	 * Vulkan Backend.
	 */
	id3DocumentProcessingUnit_Vulkan = 5,
} id3DocumentProcessingUnit;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetProcessingUnitString(int value);

#ifdef __cplusplus
}
#endif

#endif
