//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentHologramAuthenticationResult_h
#define _id3DocumentHologramAuthenticationResult_h

#include <id3Document/id3DocumentExports.h>
#include <id3Document/id3DocumentRectangle.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents the result of hologram authentication.
 */

/**
 * Handle to a HologramAuthenticationResult object of the Document module.
 */
typedef struct id3DocumentHologramAuthenticationResult *ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT;

/**
 * @brief Initializes a HologramAuthenticationResult object.
 * @param phHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResult_Initialize(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT *phHologramAuthenticationResult);

/**
 * @brief Releases the memory allocated for a HologramAuthenticationResult.
 * @param phHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResult_Dispose(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT *phHologramAuthenticationResult);

/**
 * @brief Checks if the handle object is valid.
 * @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResult_CheckHandle(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult);

/**
 * @brief Copies an instance of HologramAuthenticationResult object to another.
 * @param hHologramAuthenticationResultSrc [in] Handle to the source HologramAuthenticationResult object.
 * @param hHologramAuthenticationResultDst [in] Handle to the destination HologramAuthenticationResult object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResult_CopyTo(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResultSrc, ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResultDst);

/**
 * Gets the exact bounds of the text in the image.
 * @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
 * @param sBounds [out] Exact bounds of the text in the image.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResult_GetBounds(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult, id3DocumentRectangle *sBounds);

/**
 * Gets the correlation of the variation to the background.
 * @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
 * @param correlationScore [out] Correlation of the variation to the background.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResult_GetCorrelationScore(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult, float *correlationScore);

/**
 * Gets the name of the hologram.
 * @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
 * @param hologramName [out] Name of the hologram.
 * @param hologramNameSize [in,out] Size of the 'hologramName' buffer. Receives the minimum required buffer size to hold the 'hologramName' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'hologramName' (excluding terminating NULL character).
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResult_GetHologramName(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult, char *hologramName, int *hologramNameSize);

/**
 * Gets the variation of the OVI color.
 * @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
 * @param variationScore [out] Variation of the OVI color.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResult_GetVariationScore(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult, float *variationScore);

#ifdef __cplusplus
}
#endif

#endif
