//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentMrzHelper_h
#define _id3DocumentMrzHelper_h

#include <id3Document/id3DocumentExports.h>
#include <id3Document/id3DocumentMrzType.h>
#include <id3Document/id3DocumentStringDict.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Provides functionalities to decode and check a MRZ.
 */

/**
 * Checks the validity of a single line of an MRZ of a given type by checking the check digits.
 * @param text [in] The input MRZ line.
 * @param eType [in] The input MRZ type according to ICAO-9303 standard.
 * @param validity [out] The result of the verification.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentMrzHelper_Check(const char *text, id3DocumentMrzType eType, bool *validity);

/**
 * Decodes an MRZ of a given type and returns the values of the various fields.
 * @param text [in] The input MRZ.
 * @param eType [in] The input MRZ type according to ICAO-9303 standard.
 * @param hFields [out] A dictionary containing the fields and values decoded in the MRZ.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentMrzHelper_Decode(const char *text, id3DocumentMrzType eType, ID3_DOCUMENT_STRING_DICT hFields);

#ifdef __cplusplus
}
#endif

#endif
