//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentFormat_h
#define _id3DocumentFormat_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates document formats, according to ISO/IEC 7810.
 */
typedef enum id3DocumentFormat {
	/**
	 * Unknown document format.
	 */
	id3DocumentFormat_Unknown = 0,
	/**
	 * A4 format document
	 */
	id3DocumentFormat_A4 = 1,
	/**
	 * ID-1 format. Specifies a size of 85.60 by 53.98 millimetres. This format is commonly used for most banking cards and ID cards.
	 */
	id3DocumentFormat_Id1 = 2,
	/**
	 * ID-2 format. Specifies a size of 105 by 74 millimetres. This format is used for visas, Romanian and other ID cards. Visas. 
	 */
	id3DocumentFormat_Id2 = 3,
	/**
	 * ID-3 format. Specifies a size of 125 by 88 millimetres. This format is commonly used for passport booklets.
	 */
	id3DocumentFormat_Id3 = 4,
} id3DocumentFormat;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetDocumentFormatString(int value);

#ifdef __cplusplus
}
#endif

#endif
